<?php
/**
 * @package yeahthemes
 */

if(class_exists( 'YT_Post_Helpers') )
	YT_Post_Helpers::$listed_post[] = get_the_ID();

?>
<article class="<?php echo esc_attr( join( ' ', get_post_class( $article_class ) ) );?>">
	<header class="entry-header">
		<?php echo !empty( $cat_tag) ? $cat_tag : ''; ?>
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" title="%s">', esc_url( get_permalink() ), esc_attr( get_the_title() ) ), '</a></h2>', true );?>
	</header>
	<div class="entry-content">
		<a href="<?php echo esc_url( get_permalink() );?>" class="entry-thumbnail<?php echo ( 'mixed' == $hero_style ? esc_attr( ' goverlay-' . $overlay_color[ $count-1 ] ) : '' );?>">
		<?php
		if( !has_post_thumbnail())
			echo '<img src="data:image/gif;base64,R0lGODdhQAG+AIAAAPr6+vr6+iwAAAAAQAG+AAAC/oSPqcvtD6OctNqLs968+w+G4kiW5omm6sq27gvH8kzX9o3n+s73/g8MCofEovGITCqXzKbzCY1Kp9Sq9YrNarfcrvcLDovH5LL5jE6r1+y2+w2Py+f0uv2Oz+v3/L7/DxgoOEhYaHiImKi4yNjo+AgZKTlJWWl5iZmpucnZ6fkJGio6SlpqeoqaqrrK2ur6ChsrO0tba3uLm6u7y9vr+wscLDxMXGx8jJysvMzc7PwMHS09TV1tfY2drb3N3e39DR4uPk5ebn6Onq6+jhtQ4T4RAD8jP+8gT4FvXM//wF/v75+Mfg3+AbwncJjBgwsW6mu48IXBgg7tJXAojCAA/o0INHI8QPAjiogMGG58ePGgyF0mT1p0abGlAZMyS1QsiXJmTp32auraWROo0Jc+Raj0KTPpUGQrIeZU+jJFU6gKqB4rWnVpyqhOt1pYKfKj1X07KRLVGpBhwnhBocZESwzr1rN0I6xdK2EqXJ5ZufKaaNdtX79e+X5Fujes3HZNB9N9zNbdYpxlYXZsqbgyy8ZznULOi2+yZ7Pw8FruXGyx3qGEHWdoXPHzZc2+sMIWHJl2WsI3Uc9u/VczZ5d9DwNHqPt318Jk/Q4fC1r06OiUi19tmxx6YOmDo3PVrrDscMOz84VOTvk48erMg9e1DgE88vXGj9ve+xMz68jlvvmTN5+dXDShR4tH4hHIU2ncqYWgcmnFd1SDsvQ2F4W/jZfgW5PFxh6EgGX04YUWipibhuhxCN923LWz24gp1edbi6aBpN5l7NyIY4467shjjz7+CGSQQg5JZJFGHolkkkouyWSTTj4JZZRSTklllVZeiWWWWm7JZZdefglmmGKOSWaZZp6JZppqrslmm26+CWeccs5JZ5123olnnnruyWeffv4JaKCCDkpooYYeimiiii7KaKOOPgpppJKyUgAAOw==">';
		else{
			
			the_post_thumbnail( $thumb_size );
		}
		?>
		</a>
	</div>
	<footer class="entry-meta">
		<span class="pull-left posted-on"><i class="fa fa-clock-o"></i> <time class="entry-date published" datetime="<?php echo esc_attr( get_the_time('c') );?>"><?php echo get_the_date();?></time>
			<?php 

			if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ){
				echo $time_string = sprintf( '<time class="updated hidden" datetime="%1$s">%2$s</time>', 
					esc_attr( get_the_modified_date( 'c' ) ),
					esc_html( get_the_modified_date() )
				);
			}else{
				echo '<time class="updated hidden" datetime="' . esc_attr( get_the_time('c') ) . '">' . get_the_date() . '</time>';
			}
			?>
		</span>
		<span class="pull-right with-cmt"><i class="fa fa-comments"></i> <?php echo comments_popup_link( __( '0', 'yeahthemes' ), __( '1', 'yeahthemes' ), __( '%', 'yeahthemes' ));?></span>
		<?php 
		echo sprintf( '<span class="hidden"> by %s</span>', 
			sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				esc_attr( sprintf( __( 'View all posts by %s', 'yeahthemes' ), get_the_author() ) ),
				esc_html( get_the_author() )
			) 
		);
		?>
	</footer>
</article>