<?php
/**
 * @package yeahthemes
 */
 
	$format = get_post_format();
	
	if( false === $format )
		$format = 'standard';
	
	$formats_meta = yt_get_post_formats_meta( get_the_ID());
	

	$output_excerpt = '';
	if( 'automatic' == yt_get_options( 'excerpt_output' ) ){

		$excerpt = get_the_excerpt();

		$output_excerpt = sprintf('%s', apply_filters( 'the_content', $excerpt ) );
	}


		
	$readmore_content = 'show' == yt_get_options( 'blog_readmore_button' ) ? '<p><a class="more-tag btn btn-default btn-lg margin-top-15" href="'. get_permalink( get_the_ID() ) . ( 'manual' == yt_get_options( 'excerpt_output' ) ? "#more-" . get_the_ID() : '' ) . '"> ' . __('Read More...','yeahthemes') . '</a></p>' : '';

	/*Rating*/
	$rating_content = '';
	if( is_home() && 'show' === yt_get_options( 'blog_post_review_info' ) && function_exists( 'wp_review_show_total') ){
		$rating = wp_review_show_total(false, 'review-total-only review-mark inline-block');
		if( $rating )
			$rating_content = '<div class="margin-bottom-15">' . sprintf(__('Rating: %s', 'yeahthemes'), $rating ) . '</div>';
	}

	if(class_exists( 'YT_Post_Helpers') )
		YT_Post_Helpers::$listed_post[] = get_the_ID();
?>
<?php 
/**
 * Standard format
 ******************************************************************
 */
if( 'standard' === $format ){ ?>
<article id="post-<?php echo esc_attr( get_the_ID() ); ?>" <?php post_class(); ?>>
	<?php do_action( 'yt_before_archive_post_entry_header' );?>

	<header class="entry-header article-header">

		<?php do_action( 'yt_archive_post_entry_header_start' );?>

		<h2 class="entry-title secondary-2-primary margin-bottom-30"><a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( strip_tags( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
		
		<?php if( !is_search() && 'hide' !== yt_get_options( 'blog_post_meta_info_mode' )): ?>
		<div class="entry-meta margin-bottom-30 hidden-print" style="display:none">
			<span class="posted-on">
				
				<?php
					$time_string = '<time class="entry-date published ' . ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ? '' : 'updated' ) . 'pull-left" datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
						$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
				
					$time_string = sprintf( $time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);
					echo $time_string;
				?>
			</span>
			<span class="byline">

				<span class="author vcard">
					<a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
						<?php echo esc_html( get_the_author() ); ?>
					</a>
				</span>
			</span>			
		</div><!-- .entry-meta -->
		<?php endif; ?>

		<?php do_action( 'yt_archive_post_entry_header_end' );?>

	</header><!-- .entry-header -->

	<?php do_action( 'yt_before_archive_post_entry_content' );?>
	
	<?php if ( is_search() ) : // Only display Excerpts for Search ?>
	<div class="entry-summary margin-bottom">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="entry-content article-content">		

		<?php do_action( 'yt_archive_post_entry_content_start' );?>
		
		<?php if ( has_post_thumbnail() && get_the_post_thumbnail() && ! post_password_required() ) : ?>
		<p class="entry-thumbnail margin-bottom-30">
			<a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php the_post_thumbnail( 'post-thumbnail'); ?></a>
		</p>
		<?php endif; ?>

		<?php 
		if( 'automatic' == yt_get_options( 'excerpt_output' ) ){
			
			echo $output_excerpt;

		}else{
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'yeahthemes' ) );

			wp_link_pages( array(
				'before' => '<p class="page-links pagination-nav">' . __( 'Pages:', 'yeahthemes' ),
				'after'  => '</p>',
				'link_before' => '<span class="page-numbers">',
				'link_after' => '</span>',
			) );
		}

		echo $rating_content;
		echo $readmore_content;
		
		?>
		
		<?php do_action( 'yt_archive_post_entry_content_end' );?>

	</div><!-- .entry-content -->
	<?php endif; ?>

	<?php if ( current_user_can('edit_post', get_the_ID()) ) {?>
	<footer class="entry-meta">
		<?php edit_post_link( __( '—Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
	<?php }?>
	<!-- noptimize --><script type="text/html" data-role="header .entry-meta"><?php if( function_exists( 'yt_post_meta_description' )) yt_post_meta_description(); ?></script><!-- /noptimize -->
</article><!-- #post-<?php the_ID(); ?>## -->

<?php
}
/**
 * Video format
 ******************************************************************
 */
elseif( 'video' === $format ){?>
<article id="post-<?php echo esc_attr( get_the_ID() ); ?>" <?php post_class(); ?> >

	<?php do_action( 'yt_before_archive_post_entry_header' );?>

	<header class="entry-header article-header">

		<?php do_action( 'yt_archive_post_entry_header_start' );?>

		<h2 class="entry-title secondary-2-primary margin-bottom-30"><a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( strip_tags( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
		
		<?php if( !is_search() && 'hide' !== yt_get_options( 'blog_post_meta_info_mode' )): ?>
		<div class="entry-meta margin-bottom-30 hidden-print" style="display:none">
			<span class="posted-on">
				
				<?php
					$time_string = '<time class="entry-date published ' . ( get_the_time( 'U' ) == get_the_modified_time( 'U' ) ? 'updated' : '' ) . 'pull-left" datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
						$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
				
					$time_string = sprintf( $time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);
					echo $time_string;
				?>
			</span>
			<span class="byline">

				<span class="author vcard">
					<a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
						<?php echo esc_html( get_the_author() ); ?>
					</a>
				</span>
			</span>			
		</div><!-- .entry-meta -->
		<?php endif; ?>

		<?php do_action( 'yt_archive_post_entry_header_end' );?>

	</header><!-- .entry-header -->

	<?php do_action( 'yt_before_archive_post_entry_content' );?>
	
	<?php if ( is_search() ) : // Only display Excerpts for Search ?>
	<div class="entry-summary margin-bottom-30">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="entry-content article-content">	

		<?php do_action( 'yt_archive_post_entry_content_start' );?>
			
		<?php if ( has_post_thumbnail() && get_the_post_thumbnail() && ! post_password_required() ) : ?>
		<p class="entry-thumbnail margin-bottom-30">
			<a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() );?>"><?php the_post_thumbnail( 'post-thumbnail'); ?></a>
		</p>
		<?php endif; ?>
		
		<?php if ( !has_post_thumbnail() && yt_get_the_post_format_video() && !post_password_required() ) : ?>
		<p class="entry-format-media margin-bottom-30">
			<?php echo yt_get_the_post_format_video(); ?>
		</p>
		<?php endif; ?>
		
		<?php 
		if( 'automatic' == yt_get_options( 'excerpt_output' ) ){
			echo $output_excerpt;
		}else{
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'yeahthemes' ) );

			wp_link_pages( array(
				'before' => '<p class="page-links pagination-nav">' . __( 'Pages:', 'yeahthemes' ),
				'after'  => '</p>',
				'link_before' => '<span class="page-numbers">',
				'link_after' => '</span>',
			) );
		}

		echo $rating_content;
		echo $readmore_content;
		?>
		
		<?php do_action( 'yt_archive_post_entry_content_end' );?>

	</div><!-- .entry-content -->
	<?php endif; ?>

	<?php if ( current_user_can('edit_post', get_the_ID()) ) {?>
	<footer class="entry-meta">
		<?php edit_post_link( __( '—Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
	<?php }?>
	<!-- noptimize --><script type="text/html" data-role="header .entry-meta"><?php if( function_exists( 'yt_post_meta_description' )) yt_post_meta_description(); ?></script><!-- /noptimize -->
</article><!-- #post-<?php the_ID(); ?>## -->
<?php	
}
/**
 * Audio format
 ******************************************************************
 */
elseif( 'audio' === $format ){?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php do_action( 'yt_before_archive_post_entry_header' );?>
	
	<header class="entry-header article-header">

		<?php do_action( 'yt_archive_post_entry_header_start' );?>

		<h2 class="entry-title secondary-2-primary margin-bottom-30"><a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( strip_tags( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
		
		<?php if( !is_search() && 'hide' !== yt_get_options( 'blog_post_meta_info_mode' )): ?>
		<div class="entry-meta margin-bottom-30 hidden-print" style="display:none">
			<span class="posted-on">
				
				<?php
					$time_string = '<time class="entry-date published ' . ( get_the_time( 'U' ) == get_the_modified_time( 'U' ) ? 'updated' : '' ) . 'pull-left" datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
						$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
				
					$time_string = sprintf( $time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);
					echo $time_string;
				?>
			</span>
			<span class="byline">

				<span class="author vcard">
					<a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
						<?php echo esc_html( get_the_author() ); ?>
					</a>
				</span>
			</span>			
		</div><!-- .entry-meta -->
		<?php endif; ?>
		
		<?php do_action( 'yt_archive_post_entry_header_end' );?>

	</header><!-- .entry-header -->

	<?php do_action( 'yt_before_archive_post_entry_content' );?>
	
	<?php if ( is_search() ) : // Only display Excerpts for Search ?>
	<div class="entry-summary margin-bottom-30">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="entry-content article-content">	

		<?php do_action( 'yt_archive_post_entry_content_start' );?>
			
		<?php if ( has_post_thumbnail() && get_the_post_thumbnail() && yt_get_the_post_format_audio() && ! post_password_required() ) : ?>
		<p class="entry-thumbnail<?php echo !yt_get_the_post_format_audio() ? ' margin-bottom-30' : ''; ?>">
			<a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title()); ?>"><?php the_post_thumbnail( 'post-thumbnail'); ?></a>
		</p>
		<?php endif; ?>
		<?php if ( !post_password_required() && yt_get_the_post_format_audio() ) : ?>
		<p class="entry-format-media <?php echo has_post_thumbnail() && get_the_post_thumbnail() && ! post_password_required() ? 'with-cover ' : ''; ?>margin-bottom-30">
			<?php echo yt_get_the_post_format_audio(); ?>
		</p>
		<?php endif; ?>
		
		<?php 
		if( 'automatic' == yt_get_options( 'excerpt_output' ) ){
			echo $output_excerpt;
		}else{
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'yeahthemes' ) );

			wp_link_pages( array(
				'before' => '<p class="page-links pagination-nav">' . __( 'Pages:', 'yeahthemes' ),
				'after'  => '</p>',
				'link_before' => '<span class="page-numbers">',
				'link_after' => '</span>',
			) );
		}

		echo $rating_content;
		echo $readmore_content;
		?>
		
		<?php do_action( 'yt_archive_post_entry_content_end' );?>

	</div><!-- .entry-content -->
	<?php endif; ?>

	<?php if ( current_user_can('edit_post', get_the_ID()) ) {?>
	<footer class="entry-meta">
		<?php edit_post_link( __( '—Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
	<?php }?>
	<!-- noptimize --><script type="text/html" data-role="header .entry-meta"><?php if( function_exists( 'yt_post_meta_description' )) yt_post_meta_description(); ?></script><!-- /noptimize -->
</article><!-- #post-<?php the_ID(); ?>## -->
<?php	
}
/**
 * Gallery format
 ******************************************************************
 */
elseif( 'gallery' === $format ){?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php do_action( 'yt_before_archive_post_entry_header' );?>
	
	<header class="entry-header article-header">

		<?php do_action( 'yt_archive_post_entry_header_start' );?>

		<h2 class="entry-title secondary-2-primary margin-bottom-30"><a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( strip_tags( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
		
		<?php if( !is_search() && 'hide' !== yt_get_options( 'blog_post_meta_info_mode' )): ?>
		<div class="entry-meta margin-bottom-30 hidden-print" style="display:none">
			<span class="posted-on">
				
				<?php
					$time_string = '<time class="entry-date published ' . ( get_the_time( 'U' ) == get_the_modified_time( 'U' ) ? 'updated' : '' ) . 'pull-left" datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
						$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
				
					$time_string = sprintf( $time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);
					echo $time_string;
				?>
			</span>
			<span class="byline">

				<span class="author vcard">
					<a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
						<?php echo esc_html( get_the_author() ); ?>
					</a>
				</span>
			</span>			
		</div><!-- .entry-meta -->
		<?php endif; ?>

		<?php do_action( 'yt_archive_post_entry_header_end' );?>

	</header><!-- .entry-header -->
	
	<?php do_action( 'yt_before_archive_post_entry_content' );?>
	
	<?php if ( is_search() ) : // Only display Excerpts for Search ?>
	<div class="entry-summary margin-bottom-30">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="entry-content article-content">	

		<?php do_action( 'yt_archive_post_entry_content_start' );?>
			
		<?php if ( has_post_thumbnail() && get_the_post_thumbnail() && yt_get_the_post_format_gallery() && ! post_password_required() ) : ?>
		<p class="entry-thumbnail margin-bottom-30">
			<a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title()); ?>"><?php the_post_thumbnail( 'post-thumbnail'); ?></a>
		</p>
		<?php endif; ?>
		<?php if ( !has_post_thumbnail() && yt_get_the_post_format_gallery() && !post_password_required() ) : ?>
		<p class="entry-format-media margin-bottom-30">
			<?php echo yt_get_the_post_format_gallery(); ?>
		</p>
		<?php endif; ?>
		
		<?php 
		if( 'automatic' == yt_get_options( 'excerpt_output' ) ){
			echo $output_excerpt;
		}else{
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'yeahthemes' ) );

			wp_link_pages( array(
				'before' => '<p class="page-links pagination-nav">' . __( 'Pages:', 'yeahthemes' ),
				'after'  => '</p>',
				'link_before' => '<span class="page-numbers">',
				'link_after' => '</span>',
			) );
		}

		echo $rating_content;
		echo $readmore_content;
		?>
		
		<?php do_action( 'yt_archive_post_entry_content_end' );?>

	</div><!-- .entry-content -->
	<?php endif; ?>

	<?php if ( current_user_can('edit_post', get_the_ID()) ) {?>
	<footer class="entry-meta">
		<?php edit_post_link( __( '—Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
	<?php }?>
	<!-- noptimize --><script type="text/html" data-role="header .entry-meta"><?php if( function_exists( 'yt_post_meta_description' )) yt_post_meta_description(); ?></script><!-- /noptimize -->
</article><!-- #post-<?php the_ID(); ?>## -->
<?php	
}
/**
 * Image format
 ******************************************************************
 */
elseif( 'image' === $format ){ ?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php do_action( 'yt_before_archive_post_entry_header' );?>
	
	<header class="entry-header article-header hidden">

		<?php do_action( 'yt_archive_post_entry_header_start' );?>

		<h2 class="entry-title secondary-2-primary margin-bottom-30"><a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( strip_tags( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
		<?php if( !is_search() && 'hide' !== yt_get_options( 'blog_post_meta_info_mode' )): ?>
		<div class="entry-meta margin-bottom-30 hidden-print" style="display:none">
			<span class="posted-on">
				
				<?php
					$time_string = '<time class="entry-date published ' . ( get_the_time( 'U' ) == get_the_modified_time( 'U' ) ? 'updated' : '' ) . 'pull-left" datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
						$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
				
					$time_string = sprintf( $time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);
					echo $time_string;
				?>
			</span>
			<span class="byline">

				<span class="author vcard">
					<a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
						<?php echo esc_html( get_the_author() ); ?>
					</a>
				</span>
			</span>			
		</div><!-- .entry-meta -->
		<?php endif; ?>
		<?php do_action( 'yt_archive_post_entry_header_end' );?>

	</header><!-- .entry-header -->
	
	<?php do_action( 'yt_before_archive_post_entry_content' );?>
	
	<?php if ( is_search() ) : // Only display Excerpts for Search ?>
	<div class="entry-summary margin-bottom-30">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="entry-content article-content">

		<?php do_action( 'yt_archive_post_entry_content_start' );?>
				
		<?php if ( ! post_password_required() && yt_get_the_post_format_image() ) : ?>
		<p class="entry-media margin-bottom-30">
		<?php echo yt_get_the_post_format_image(); ?>
		</p>
		<?php endif; ?>
		
		<?php 
		if( 'automatic' == yt_get_options( 'excerpt_output' ) ){
			echo $output_excerpt;
		}else{
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'yeahthemes' ) );

			wp_link_pages( array(
				'before' => '<p class="page-links pagination-nav">' . __( 'Pages:', 'yeahthemes' ),
				'after'  => '</p>',
				'link_before' => '<span class="page-numbers">',
				'link_after' => '</span>',
			) );
		}

		echo $rating_content;
		echo $readmore_content;
		?>
		
		<?php do_action( 'yt_archive_post_entry_content_end' );?>

	</div><!-- .entry-content -->
	<?php endif; ?>

	<?php if ( current_user_can('edit_post', get_the_ID()) ) {?>
	<footer class="entry-meta">
		<?php edit_post_link( __( '—Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
	<?php }?>
	<!-- noptimize --><script type="text/html" data-role="header .entry-meta"><?php if( function_exists( 'yt_post_meta_description' )) yt_post_meta_description(); ?></script><!-- /noptimize -->
</article><!-- #post-<?php the_ID(); ?>## -->

<?php
}/**
 * Quote format
 ******************************************************************
 */
elseif( 'quote' === $format ){
	/*if( has_post_thumbnail() ){
		
		$thumb_id = get_post_thumbnail_id();
		$thumb = wp_get_attachment_image_src($thumb_id,'thumbnail-size', true);
		$quote_bg = sprintf( ' style="background:url(%s);background-size:cover;"', esc_url( $thumb[0] )  );
	}*/
	
	//print_r($formats_meta);
	$quote_author = !empty( $formats_meta['_format_quote_source_name'] )  ? '<cite class="margin-bottom-30">' . $formats_meta['_format_quote_source_name'] . '</cite>' : '';
	$quote_author = !empty( $formats_meta['_format_quote_source_url'] ) ? sprintf( '<cite class="entry-format-meta margin-bottom-30"><a href="%s">%s</a></cite>', $formats_meta['_format_quote_source_url'], $formats_meta['_format_quote_source_name'] ) : $quote_author;
	
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( ( isset( $quote_bg ) ? 'has-background' : '' )); ?>>

	<?php do_action( 'yt_before_archive_post_entry_header' );?>
	
	<header class="entry-header article-header"<?php echo isset( $quote_bg ) ? $quote_bg : '';?>>

		<?php do_action( 'yt_archive_post_entry_header_start' );?>

		<h2 class="entry-title secondary-2-primary margin-bottom-30"><a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( strip_tags( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
		<?php echo $quote_author;?>
		<?php if( !is_search() && 'hide' !== yt_get_options( 'blog_post_meta_info_mode' )): ?>
		<div class="entry-meta margin-bottom-30 hidden-print" style="display:none">
			<span class="posted-on">
				
				<?php
					$time_string = '<time class="entry-date published ' . ( get_the_time( 'U' ) == get_the_modified_time( 'U' ) ? 'updated' : '' ) . 'pull-left" datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
						$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
				
					$time_string = sprintf( $time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);
					echo $time_string;
				?>
			</span>
			<span class="byline">

				<span class="author vcard">
					<a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
						<?php echo esc_html( get_the_author() ); ?>
					</a>
				</span>
			</span>			
		</div><!-- .entry-meta -->
		<?php endif; ?>

		<?php do_action( 'yt_archive_post_entry_header_end' );?>

	</header><!-- .entry-header -->
	
	<?php do_action( 'yt_before_archive_post_entry_content' );?>
	
	<?php if ( is_search() ) : // Only display Excerpts for Search ?>
	<div class="entry-summary margin-bottom-30">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="entry-content article-content">		

		<?php do_action( 'yt_archive_post_entry_content_start' );?>

		<?php if ( has_post_thumbnail() && get_the_post_thumbnail() && ! post_password_required() ) : ?>
		<p class="entry-thumbnail margin-bottom-30">
			<a href="<?php echo esc_attr( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title()); ?>"><?php the_post_thumbnail( 'post-thumbnail'); ?></a>
		</p>
		<?php endif; ?>		
		
		<?php 
		if( 'automatic' == yt_get_options( 'excerpt_output' ) ){
			echo $output_excerpt;
		}else{
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'yeahthemes' ) );

			wp_link_pages( array(
				'before' => '<p class="page-links pagination-nav">' . __( 'Pages:', 'yeahthemes' ),
				'after'  => '</p>',
				'link_before' => '<span class="page-numbers">',
				'link_after' => '</span>',
			) );
		}

		echo $rating_content;
		echo $readmore_content;
		?>
		
		<?php do_action( 'yt_archive_post_entry_content_end' );?>

	</div><!-- .entry-content -->
	<?php endif; ?>

	<?php if ( current_user_can('edit_post', get_the_ID()) ) {?>
	<footer class="entry-meta">
		<?php edit_post_link( __( '—Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
	<?php }?>
	<!-- noptimize --><script type="text/html" data-role="header .entry-meta"><?php if( function_exists( 'yt_post_meta_description' )) yt_post_meta_description(); ?></script><!-- /noptimize -->
</article><!-- #post-<?php the_ID(); ?>## -->

<?php
}
/**
 * Link format
 ******************************************************************
 */
elseif( 'link' === $format ){
	
	$share_url = !empty( $formats_meta['_format_link_url'] ) ? $formats_meta['_format_link_url'] : get_permalink( get_the_ID() );
	
	//print_r($formats_meta);
	$share_url_text = !empty( $formats_meta['_format_link_url'] )  
		? sprintf( '<div class="entry-format-meta margin-bottom-30">%s <a href="%s">#</a></div>',
			$formats_meta['_format_link_url'],
			get_permalink( get_the_ID() ) )
		: '';
	
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?><?php echo isset( $quote_bg ) ? $quote_bg : '';?>>

	<?php do_action( 'yt_before_archive_post_entry_header' );?>
	
	<header class="entry-header article-header">

		<?php do_action( 'yt_archive_post_entry_header_start' );?>

		<h2 class="entry-title secondary-2-primary margin-bottom-30"><a href="<?php echo esc_url( $share_url ); ?>" rel="bookmark" title="<?php echo esc_attr( strip_tags( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
		<?php echo $share_url_text;?>
		<?php if( !is_search() && 'hide' !== yt_get_options( 'blog_post_meta_info_mode' )): ?>
		<div class="entry-meta margin-bottom-30 hidden-print" style="display:none">
			<span class="posted-on">
				
				<?php
					$time_string = '<time class="entry-date published ' . ( get_the_time( 'U' ) == get_the_modified_time( 'U' ) ? 'updated' : '' ) . 'pull-left" datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
						$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
				
					$time_string = sprintf( $time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);
					echo $time_string;
				?>
			</span>
			<span class="byline">

				<span class="author vcard">
					<a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
						<?php echo esc_html( get_the_author() ); ?>
					</a>
				</span>
			</span>			
		</div><!-- .entry-meta -->
		<?php endif; ?>

		<?php do_action( 'yt_archive_post_entry_header_end' );?>
	</header><!-- .entry-header -->
	
	<?php do_action( 'yt_before_archive_post_entry_content' );?>
	
	<?php if ( is_search() ) : // Only display Excerpts for Search ?>
	<div class="entry-summary margin-bottom-30">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="entry-content article-content">	

		<?php do_action( 'yt_archive_post_entry_content_start' );?>

		<?php if ( has_post_thumbnail() && get_the_post_thumbnail() && ! post_password_required() ) : ?>
		<p class="entry-thumbnail margin-bottom-30">
			<a href="<?php echo esc_url( $share_url ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title()); ?>"><?php the_post_thumbnail( 'post-thumbnail'); ?></a>
		</p>
		<?php endif; ?>
				
		<?php 
		if( 'automatic' == yt_get_options( 'excerpt_output' ) ){
			echo $output_excerpt;
		}else{
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'yeahthemes' ) );

			wp_link_pages( array(
				'before' => '<p class="page-links pagination-nav">' . __( 'Pages:', 'yeahthemes' ),
				'after'  => '</p>',
				'link_before' => '<span class="page-numbers">',
				'link_after' => '</span>',
			) );
		}

		echo $rating_content;
		echo $readmore_content;
		?>
		
		<?php do_action( 'yt_archive_post_entry_content_end' );?>

	</div><!-- .entry-content -->
	<?php endif; ?>

	<?php if ( current_user_can('edit_post', get_the_ID()) ) {?>
	<footer class="entry-meta">
		<?php edit_post_link( __( '—Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->
	<?php }?>
	<!-- noptimize --><script type="text/html" data-role="header .entry-meta"><?php if( function_exists( 'yt_post_meta_description' )) yt_post_meta_description(); ?></script><!-- /noptimize -->
</article><!-- #post-<?php the_ID(); ?>## -->

<?php
}
?>