<?php
// This file is not called from WordPress. We don't like that.
! defined( 'ABSPATH' ) and exit;


/**
 * Custom fields for Category
 *
 * @package   Yeahthemes
 * @author		Yeahthemes
 * @copyright	Copyright ( c ) Yeahthemes
 * @since     1.0
 */
class YT_Category_Custom_Fields{
	/**
	 * Constructor
	 */
	public function __construct() {

		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		add_action( 'admin_print_styles', array( $this, 'admin_print_styles' ), 10 );
		add_action( 'admin_print_footer_scripts', array( $this, 'admin_print_footer_scripts' ), 10 );
		// Add form
		add_action( 'category_add_form_fields', array( $this, 'add_category_fields' ) );
		add_action( 'category_edit_form_fields', array( $this, 'edit_category_fields' ), 10 );
		add_action( 'created_category', array( $this, 'save_category_fields' ) );
		add_action( 'edited_category', array( $this, 'save_category_fields' ) );
	}
	/**
	 * Style
	 *
	 * @access public
	 * @return void
	 */
	function admin_enqueue_scripts(){
		global $hook_suffix, $pagenow, $current_screen;
		
		if( 'edit-tags.php' !== $pagenow && 'edit-category' !== $current_screen->id )
    		return;

   		wp_enqueue_style( 'wp-color-picker' );
  		wp_enqueue_script( 'wp-color-picker');
	}

	function admin_print_styles(){
		global $hook_suffix, $pagenow, $current_screen;

    	if( 'edit-tags.php' !== $pagenow && 'edit-category' !== $current_screen->id )
    		return;

		echo str_replace(array("\r", "\n", "\t"), "",'<style type="text/css">
		.wp-picker-container .button{
			width: auto;
		}
		</style>');
	}
	/**
	 * Scripts
	 *
	 * @access public
	 * @return void
	 */
	function admin_print_footer_scripts() {
    	global $hook_suffix, $pagenow, $current_screen;

    	if( 'edit-tags.php' !== $pagenow && 'edit-category' !== $current_screen->id )
    		return;

    	echo str_replace(array("\r", "\n", "\t"), "", '<script type="text/javascript">
		/* <![CDATA[ */
		;(function ($) {
			$(\'.yt-color-picker\').each(function(index, element) {
				var $el = $(this);			
				var myOptions = {
					
					defaultColor: $el.data(\'std\'),
					change: function(event, ui){},
					clear: function() {},
					hide: true,
					palettes: true
				};
				 
				$el.wpColorPicker(myOptions);

			});
		})(jQuery);
		/* ]]> */
		</script>' );
	}

	/**
	 * Category thumbnail fields.
	 *
	 * @access public
	 * @return void
	 */
	public function add_category_fields() {
		?>
		
		<div class="form-field">
			<label for="display_type"><?php esc_html_e( 'Accent color', 'yeahthemes' ); ?></label>
			<input data-std="" id="category_color" class="yt-color-picker" name="category_meta[color]" type="text" value="" />
		</div>
		
		<?php
	}

	/**
	 * Edit category thumbnail field.
	 *
	 * @access public
	 * @param mixed $term Term (category) being edited
	 */
	public function edit_category_fields( $term ) {
		$t_id = $term->term_id;
    	$cat_meta = get_option( "category_$t_id");
		?>
		<tr class="form-field">
			<th scope="row" valign="top"><label><?php esc_html_e( 'Accent color', 'yeahthemes' ); ?></label></th>
			<td>
				<input data-std="" id="category_color" class="yt-color-picker" name="category_meta[color]" type="text" value="<?php echo isset( $cat_meta['color'] ) ? esc_attr( $cat_meta['color'] ) : '';?>" size="7" />
			</td>
		</tr>
		
		<?php
	}

	/**
	 * save_category_fields function.
	 *
	 * @access public
	 * @param mixed $term_id Term ID being saved
	 * @return void
	 */
	public function save_category_fields( $term_id ) {
		
		if ( isset( $_POST['category_meta'] ) ) {
			$cat_meta = get_option( "category_$term_id") ? get_option( "category_$term_id") : array();

	        $cat_keys = array_keys($_POST['category_meta']);
			//print_r($cat_keys); die();
            foreach ($cat_keys as $key){
	            if (isset($_POST['category_meta'][$key])){
	                $cat_meta[$key] = $_POST['category_meta'][$key];
	            }
	        }
	        //save the option array
	        update_option( "category_$term_id", $cat_meta );
    	}
	}
	/**
	 * get_category_meta function.
	 *
	 * @access public
	 * @param mixed $term_id Term ID being saved
	 * @param mixed $key
	 * @return mixed
	 */
	public function get_category_meta( $term_id, $key ){
		if( !$term_id )
			return;
		
		$cat_meta = get_option( "category_$term_id");

		return isset( $key ) ? $cat_meta[$key] : '';
	}

}
