<?php
$hero_query = new WP_Query( apply_filters( 'yt_site_hero_banner_query', $hero_brick_query_args, $post_id ) );

if ( $hero_query->have_posts() && $hero_query->post_count >= $postsperpage ) {
	/*Begin site hero*/ 
	echo '<div id="site-hero" class="site-hero ' . esc_attr( $hero_class ) . ' border-bottom clearfix hidden-print' . ( 'none' == $hero_effect ? '' : ' yt-loading fadeIn animated' ) . '" data-layout="'.esc_attr( $hero_layout ).'" data-style="'.esc_attr( $hero_style ).'" data-effect="'.esc_attr( $hero_effect ).'">
		<div class="container">
			<div class="row">';
		/*Slider wrapper for carousel*/
		if( 'carousel' == $hero_layout ){
			echo '<div class="yeahslider" data-init="false" data-settings="' . esc_attr( json_encode( $slider_settings ) ) . '">
				<ul class="slides">';
		}
	$count = 0;
	/*Start the Loop*/ 
	while ( $hero_query->have_posts() ) {
		$hero_query->the_post();
		$count++;
		/*Push the id to array*/
		$hero_post_ids[] = $hero_query->post->ID;

		if( $count > $postsperpage )
			break;

		if( class_exists( 'YT_Post_Helpers') )
			YT_Post_Helpers::$listed_post[] = get_the_ID();

		$class 				= '';
		$thumb_size 		= 'medium';
		$thumb_holder_size 	= '320x190';
		$categories 		= get_the_category();
		$cat_tag 			= '';
		$column_size		= 'col-md-6 ';

		
		if( ( 1 == $count && 'default' == $hero_layout ) || ( in_array( $count, array( 1, 6 ) ) && 'symmetry_brick' == $hero_layout ) ){
			$class 			= ' hero-brick-large';
			$thumb_size 	= 'post-thumbnail';
			$thumb_holder_size = '670x410';
		}
		/*Category tag*/
		if( !empty( $categories[0] ) && apply_filters( 'yt_site_hero_element_cat', true, $post_id ) ){
			$category 	= $categories[0];
			$cat_tag  	.= '<span class="entry-category">';
			$cat_tag 	.= '<a class="cat-tag ' . esc_attr( $category->slug ) . '" href="'. esc_attr( get_category_link( $category->term_id ) ) .'" title="' . esc_attr( sprintf( __( 'View all posts in %s', 'yeahthemes' ), $category->name ) ) . '">'.$category->cat_name.'</a>';
			$cat_tag 	.= '</span>';
			//$class 		.= ' category-' . $category->slug;
		}
		/*Symmetric large brick*/
		if( in_array( $count, array( 1, 6 ) ) && 'symmetry_brick' == $hero_layout ){
			$column_size = 'col-md-12 ';
		}
		/*Carousel brick*/
		if( 'carousel' == $hero_layout ){
			$column_size = 'col-sm-6 col-md-3 ';
			if( 1 == $count )
				echo '<li>';
		}
		/*Symmetric & default layout*/
		if( in_array( $hero_layout, array( 'symmetry_brick', 'default' ) ) ){
			if( in_array( $count, array( 2, 3, 4, 5 ) ) )
				$column_size = 'col-sm-6 ' . $column_size;
			if( 6 == $count )
				$column_size = 'hidden-sm ' . $column_size;
		}

		$article_class = $column_size . 'hero-brick' . $class . ' clearfix' . ( 'none' == $hero_effect ? '' : ' visibility-hidden' ) ;

		if( ( 2 == $count && 'default' == $hero_layout ) || ( in_array( $count, array( 1, 4 ) ) && 'symmetry_brick' == $hero_layout ) ){
			echo '<div class="col-md-6">
			<div class="row">';
		}

			include( locate_template( 'content-hero-post.php' ) );

		if( ( 5 == $count && 'default' == $hero_layout ) || ( in_array( $count, array( 3, 6 ) ) && 'symmetry_brick' == $hero_layout ) ){
			echo '</div>
			</div>';
		}
		/*Carousel brick*/
		if( 'carousel' == $hero_layout ){
			
			if($count > 1 && 0 == $count % 4 && $count < $hero_query->post_count ){
                //$count = 0;
                echo '</li><li>';
            }

            if( $count == $hero_query->post_count ){
                echo '</li>';
            }
		}
	
	}/*End the loop*/

		/* End slider wrapper for Carousel */
		if( 'carousel' == $hero_layout ){
			echo '</ul>
				</div>';
		}

	/*End site hero*/ 
		echo '</div>
		</div>
	</div>';
} else {
	// no posts found
	echo '<div id="site-hero" class="site-hero border-bottom clearfix hidden-print yt-loading fadeIn animated text-center"><h3>' . __('You need to add more than 5 posts so the hero banner can show blocks properly', 'yeahthemes') . '</h3></div>';
}