<?php
 // This file is not called from WordPress. We don't like that.
! defined( 'ABSPATH' ) and exit;
/**
 **********************************************************************************************************
 * 												DO NOT EDIT THIS FILE
 **********************************************************************************************************
 * Theme functions
 *
 * @author		Yeahthemes
 * @copyright	Copyright ( c ) Yeahthemes
 * @link		http://yeahthemes.com
 * @since		Version 1.0
 * @package 	Yeah Includes
 */

/**
 * Top bar
 *
 * @since 1.0.3
 */
if( !function_exists( 'yt_site_top_bar' ) ){
	function yt_site_top_bar(){

		if( 'hide' == yt_get_options( 'header_top_bar_menu' ) )
			return;		
			
		get_template_part( 'includes/templates/top-bar' );
	}

}

if ( ! function_exists( 'yt_site_start_header_banner' ) ) {
	
	function yt_site_start_header_banner(){

		echo apply_filters( 'yt_site_start_header_banner',
		'<div class="site-banner" id="site-banner">
			<div class="container">
				<div class="row">' );
	}
}


if ( ! function_exists( 'yt_site_end_header_banner' ) ) {
	
	function yt_site_end_header_banner(){
		echo apply_filters( 'yt_site_end_header_banner',
				'</div>
			</div>
		</div>' );
	}
}

/**
 * Branding
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_branding' ) ) {
	
	function yt_site_branding(){
		
		get_template_part( 'includes/templates/site-branding' );
		
	}
}

/**
 * Primary Nav
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_primary_nav' ) ) {
	 
	function yt_site_primary_nav(){
		get_template_part( 'includes/templates/main-navigation' );
		
	}
}
/**
 * Menu icon class
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_nav_menu_description_icon' ) ) {
	function yt_site_nav_menu_description_icon ( $array = array(), $atts ) {
		
		/*$array['parent'] = !empty( $atts['description'] ) ? $atts['description'] : '';
		$array['children'] = !empty( $atts['description'] ) ? $atts['description'] : '';*/
		$array['before'] = !empty( $atts['description'] ) ? '<i class="' . esc_attr( $atts['description'] ) . '">' : '';
		$array['after'] = !empty( $atts['description'] ) ? '</i>' : '';
		
		
		return $array;
		
	}
}
/**
 * Custom Menu item: Search
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_custom_menu_item' ) ) {
	function yt_site_custom_menu_item ( $items, $args ) {
		
		/*$items = '<li class="menu-item menu-item-type-custom menu-item-social-networks mega-menu-parent">
			<a href="#"><i class="fa fa-reorder"></i> Menu</a>
			<div class="mega-menu-content-wrapper full-width-wrapper">
				<div class="container">
					<ul class="sub-menu">
						<li id="menu-item-517" class="menu-item"><a href="http://192.168.1.15/framework/category/uncategorized/">Uncategorized</a></li>
						<li id="menu-item-518" class="menu-item"><a href="http://192.168.1.15/framework/category/audio/">Audio</a></li>
						<li id="menu-item-519" class="menu-item"><a href="http://192.168.1.15/framework/category/link/">Link</a></li>
						<li id="menu-item-520" class="menu-item"><a href="http://192.168.1.15/framework/category/link/video/">Video</a></li>
						<li id="menu-item-521" class="menu-item"><a href="http://192.168.1.15/framework/category/link/video/hello-x/">Hello</a></li>
						<li id="menu-item-522" class="menu-item"><a href="">Image</a></li>
					</ul>
				</div>
			</div>
		</li>';*/
		if( $args->theme_location == 'primary' ){

		  

			$data_settings = 'modal' == yt_get_options('site_search_type') ? ' data-action="open-modal" data-selector=".site-modal" data-role="search" data-remove-class="hidden" data-add-class="active" data-body-active="modal-active modal-search-active overflow-hidden"' : '';

	      	$items .= '<li class="menu-item menu-item-type-custom menu-item-gsearch default-dropdown sub-menu-left pull-right"' . $data_settings . '>
				<a href="javascript:void(0);"><i class="fa fa-search"></i></a>';
				if( 'default' == yt_get_options('site_search_type') ){
					$items .= '<ul class="sub-menu">
						<li class="menu-item">
							' . get_search_form( false ) . '
						</li>
					</ul>';
				}
			$items .= '</li>';

			if( 'main_menu' === yt_get_options( 'header_social_links_position' ) ):

				$items .= '<li class="menu-item-type-custom menu-item-social-networks">' . yt_site_social_networks() . '</li>';

			endif;
		}elseif( $args->theme_location == 'mobile' ){
			// $items = '<li class="menu-item-mobile-menu-logo">
			// 		<a href="' . esc_url( home_url( '/' ) ) . '" title="' . esc_attr( yt_get_options('plain_logo_text') ) . '" rel="home"><img src="'. esc_url( yt_get_options('logo') ) .'" alt="' . esc_attr( yt_get_options('plain_logo_text') ) . '">' . '</a>
			// 	</li>' . $items;

			
		}
   
   		return $items;
   	}
}

/**
 * Ajax News Mega menu
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_ajax_mega_menu_by_category' ) ) {
	
	function yt_site_ajax_mega_menu_by_category( ){

		$nonce = isset( $_GET['nonce'] ) ? $_GET['nonce'] : '';
		$data_cat = isset( $_GET['data_cats'] ) ? $_GET['data_cats'] : '';
		$atts = isset( $_GET['atts'] ) ? $_GET['atts'] : '';
		if ( ! wp_verify_nonce( $nonce, THEMESLUG . '_mega_menu' ) )
			die();
		
		if( !$data_cat )
			die();

		$output = '';
		$category_list = explode(',', $data_cat);


		ob_start();

		include( locate_template('includes/templates/megamenu-ajax.php' ) );
		

		$html = ob_get_clean();

		
		$return = array(
			'success' => true,
			'html'	=> $html,
		);

		//
		wp_send_json( $return );

		//print_r(get_the_category(1));
		
		
		die(1);
    }
}

/**
 * Regular News Mega menu
 *
 * @since 1.0.3
 */
if ( ! function_exists( 'yt_site_usual_mega_menu_by_category' ) ) {
	
	function yt_site_usual_mega_menu_by_category( $output, $mega_menu, $data_cat, $depth, $atts  ){

		if( !$data_cat )
			return $output;

		if( $depth > 0 )
			return $output;

		if( empty( $mega_menu ) )
			return $output;

		if( 'news' !== $mega_menu )
			return $output;

		$output = '';

		$output .= '';

	ob_start();


		include( locate_template('includes/templates/megamenu-regular.php' ) );
				
		$content = ob_get_contents();
		
	ob_end_clean();

		$output .= $content;
		
		return $output;
    }
}

/**
 * Ajax News Sub
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_ajax_sub_mega_menu_by_category' ) ) {
	
	function yt_site_ajax_sub_mega_menu_by_category( ){

		$nonce = isset( $_GET['nonce'] ) ? $_GET['nonce'] : '';
		$data_cat = isset( $_GET['data_cat'] ) ? $_GET['data_cat'] : '';
		if ( ! wp_verify_nonce( $nonce, THEMESLUG . '_mega_menu' ) )
			die();
		
		if( !$data_cat )
			die();

		$output = '';

		global $post;

		$post_backup = $post;

		$myposts = get_posts( apply_filters( 'yt_site_ajax_sub_mega_menu_by_category_query', array( 
			'posts_per_page' => 5, 
			'cat' => $data_cat,
			) )
		);

		$count = 0;
		foreach ( $myposts as $post ) :
			setup_postdata( $post ); 

			$count++;

			$post_cat = get_category( $data_cat );
			$cat_tag_args = array();

			$cat_tag_args['cat_ID'] = $post_cat->cat_ID;
			$cat_tag_args['name'] = $post_cat->name;
			$cat_tag_args['slug'] = $post_cat->slug;
			?>
			<li data-filter="<?php echo esc_attr( $data_cat );?>" style="<?php /*echo 'animation-delay:' . ($count * .1) .'s;-webkit-animation-delay:' . ($count* .1) .'s;';*/?>" class="post-with-large-thumbnail <?php echo 5 == $count || 4 == $count ? 'hidden-md ' : ''; ?>col-md-3 col-lg-2">
				
					<?php if ( has_post_thumbnail() && get_the_post_thumbnail() && ! post_password_required() ) : ?>
					<div class="post-thumb large">
						<span class="cat-tag <?php echo esc_attr($cat_tag_args['slug'] );?>"><?php echo $cat_tag_args['name'];?></span>
						<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php the_post_thumbnail('medium'); ?></a>
					</div>
					<?php endif;?>
					
					<time class="entry-date" datetime="<?php echo esc_attr( get_the_time('c') ); ?>"><?php the_date();?></time>
					
					<h3 class="secondary-2-primary no-margin-bottom"><a href="<?php the_permalink();?>" rel="bookmark"><?php the_title();?></a></h3>
					
				
			</li>

			<?php

		endforeach;
		//print_r(get_the_category(1));
		wp_reset_postdata();
		
		$post = $post_backup;
		
		die(1);
    }
}

/**
 * Ajax Mobile Menu
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_mobile_nav' ) ) {
	 
	function yt_site_mobile_nav(){
		
		//Navnav
		if ( has_nav_menu( 'mobile' ) ) {
			$mobile_menu = wp_nav_menu(
				apply_filters( 'yt_site_mobile_navigation_args', array( 
					'theme_location' => 'mobile' , 
					'echo' => false, 
					'container' => false,
					'menu_class'      => 'menu',
					'menu_id'			=> 'mobile-main-menu',
					// 'depth' => 2,
					'walker' => new YT_Walker_Nav_Menu()
				))
			);
		}else{
			$mobile_menu = '<ul class="menu"><li>' . sprintf( __('Create a Menu for small screen in <a href="%s">Menus</a> and assign it as Mobile Menu in <a href="%s">Theme Location</a>', 'yeahthemes'), admin_url('nav-menus.php'), admin_url('nav-menus.php?action=locations') ) . '</li></ul>';
		}
		
		$site_navigaton = $mobile_menu ;
		
		//Allow editing site
		$site_navigaton = yt_apply_atomic( 'site_mobile_menu', $site_navigaton );
		
		echo $site_navigaton;
	}
}
add_filter( 'yt_nav_menu_link_end', 'yt_menu_item_indicator', 10, 4 );
/*
 * Menu indicator
 *
 * @since 1.0
 */
function yt_menu_item_indicator( $content, $item, $depth, $args ){
	
	// if( 0 == $depth && in_array( 'menu-item-has-children', (array) $item->classes ) )
	// 	return '<i class="fa fa-angle-down menu-item-indicator"></i>';
	
	if( $depth > 0 && in_array( 'menu-item-has-children', (array) $item->classes ) )
		return '<i class="fa fa-caret-right menu-item-indicator"></i>';
	elseif( $depth == 0 && in_array( 'menu-item-has-children', (array) $item->classes ) )
		return '<i class="fa fa-caret-down menu-item-indicato.r"></i>';
	//yt_pretty_print($item);

	return $content;

}
if ( ! function_exists( 'yt_site_ajax_mobile_menu' ) ) {
	
	function yt_site_ajax_mobile_menu( ){
		$nonce = isset( $_GET['nonce'] ) ? $_GET['nonce'] : '';

		if ( ! wp_verify_nonce( $nonce, THEMESLUG . '_mobile_menu' ) )
			die();

		yt_site_mobile_nav();
		die(1);
	}
}

if( !function_exists( 'yt_site_hidden_mobile_nav' ) ){
	function yt_site_hidden_mobile_nav( ){
		get_template_part( 'includes/templates/mobile-menu' );
	}
}
/**
 * Site social network
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_social_networks' ) ) {
	 
	function yt_site_social_networks( $return = true){
		
		$yt_data = yt_get_options();

		$network_array = apply_filters( 'yt_site_social_networks_args', array( 
			'facebook' => array(
				'title' => __('Facebook', 'yeahthemes'),
				'icon' => 'fa fa-facebook'
			), 
			'twitter' => array(
				'title' => __('Twitter', 'yeahthemes'),
				'icon' => 'fa fa-twitter'
			), 
			'googleplus' => array(
				'title' => __('Google+', 'yeahthemes'), 
				'icon' => 'fa fa-google-plus'
			),
			'youtube' => array(
				'title' => __('Youtube', 'yeahthemes'), 
				'icon' => 'fa fa-youtube'
			),
			'email' => array(
				'title' => __('Send an Email', 'yeahthemes'), 
				'icon' => 'fa fa-envelope'
			),
			'rss' => array(
				'title' => __('RSS Feed', 'yeahthemes'),
				'icon' => 'fa fa-rss'
			),
			'pinterest' => array(
				'title' => __('Pinterest', 'yeahthemes'),
				'icon' => 'fa fa-pinterest'
			),
			'vimeo' => array(
				'title' => __('Vimeo', 'yeahthemes'),
				'icon' => 'fa fa-vimeo-square'
			),
			'instagram' => array(
				'title' => __('Instagram', 'yeahthemes'),
				'icon' => 'fa fa-instagram'
			),
			'dribbble' => array(
				'title' => __('Dribbble', 'yeahthemes'),
				'icon' => 'fa fa-dribbble'
			)
		) );
		
		$social_networks ='';

		foreach( $network_array as $network	 => $settings ){

			if( !empty( $yt_data["scl_$network"] ) ){
				if( 'email' == $network ){
					$value = 'mailto:' . antispambot( $yt_data["scl_$network"] );
				}else{
					$value = esc_url( $yt_data["scl_$network"] );
				}
				$social_networks .= sprintf('<a href="%s" target="_blank" title="%s"><i class="%s"></i></a>',
					$value ,
					$settings['title'],
					esc_attr( $settings['icon'] )
				);
			}
		}

		if( $return  )
			return $social_networks;
		else
			echo $social_networks;
	}
}

/**
 * Archive header
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_archive_header' ) ) {
	
	function yt_site_archive_header(){
		if(!is_archive())
			return;

		if( yt_is_woocommerce() )
			return;

		if( yt_is_bbpress() )
			return;
		
		
		get_template_part( 'includes/templates/archive-title' );
	}
}
/**
 * Brick layout
 *
 * @since 1.0
 */ 

function yt_site_hero_banner(){
	yt_site_featured_news();
}

function yt_site_hero_banner_ids(){
	return yt_site_featured_news( 'ids' );
}

if ( ! function_exists( 'yt_site_featured_news' ) ) {
	
	function yt_site_featured_news( $output_data = 'html' ){

		if( !is_page() && !is_home() && !is_front_page() && !yt_is_woocommerce() )
			return;

		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

		global $post;
		/*Backup global post*/
		$backup_post = $post;

		$post_id = !empty( $post->ID ) ? $post->ID : 0;

		if( is_home() ){
			$post_id = get_option( 'page_for_posts' );
		}

		if( yt_is_woocommerce() && is_shop() && wc_get_page_id('shop') )
			$post_id = wc_get_page_id('shop');

		/*Allow filtering to show site hero on paged page for post*/
		if( is_paged() && ( 'html' == $output_data ) && !apply_filters( 'yt_site_hero_banner_allow_on_paged', false, $post_id ) ){
			return;
		}

		$hero_mode = get_post_meta( $post_id, 'yt_page_herobanner_mode', true  );
		
		if( !$hero_mode )
			return;

		$hero_layout 	= get_post_meta( $post_id, 'yt_page_herobanner_layout', true );
		$hero_style 	= get_post_meta( $post_id, 'yt_page_herobanner_style', true );
		$hero_effect	= get_post_meta( $post_id, 'yt_page_herobanner_effect', true );
		$hero_style_random = get_post_meta( $post_id, 'yt_page_herobanner_style_random', true );
		$categoryin 	= get_post_meta( $post_id, 'yt_page_herobanner_category', true  );
		$order 			= get_post_meta( $post_id, 'yt_page_herobanner_order', true );
		$orderby 		= get_post_meta( $post_id, 'yt_page_herobanner_orderby', true );
		$postsperpage 	= get_post_meta( $post_id, 'yt_page_herobanner_postsperpage', true );
		$postin 		= get_post_meta( $post_id, 'yt_page_herobanner_postin', true );
		$tagin 			= get_post_meta( $post_id, 'yt_page_herobanner_tagin', true );
		$exclude_format	= get_post_meta( $post_id, 'yt_page_herobanner_excludeformat', true );

		/*Asign post number*/ 
		$postsperpage = !empty( $postsperpage  ) && $postsperpage > 4 ? $postsperpage  : 8;

		if( 'default' == $hero_layout ){
			$postsperpage = 5;
		}
		elseif( 'symmetry_brick' == $hero_layout ){
			$postsperpage = 6;
		}

		/*Class style*/
		$hero_class = $hero_layout;
		if( 'color' == $hero_style ){
			$hero_class .= ' style-color-gradient';
		}elseif( 'mixed' == $hero_style ){
			$hero_class .= ' style-mixed-color-gradient';
		}
		/*overlay color*/
		$overlay_color = array( 
			'shamrock-skyblue', 
			'cerise-yellow',
			'yellow-skyblue',
			'shamrock-yellow',
			'waikawagray-cerise',
			'pictonblue-purple'
		);
		/*If is randon , do shuffling an array*/
		if( 'mixed' == $hero_style && $hero_style_random ){			
			shuffle( $overlay_color );
		}

		/*Begin query*/ 
		$hero_brick_query_args = array(
			'order' 			=> $order ? $order : 'DESC',
			'orderby' 			=> $orderby ? $orderby : 'date',
			'posts_per_page' 	=> intval( $postsperpage ),
			'post_type' 		=> 'post',
			'post_status' 		=> 'publish',
			'ignore_sticky_posts' => 1,
		);

		/* Push category to query*/
		if( !empty( $categoryin ) && is_array( $categoryin ) )
			$hero_brick_query_args['cat'] = join( ',', $categoryin );

		$postin = array_filter( (array) $postin  );
		/* Push Specified post to query*/
		if( !empty( $postin ) && is_array( $postin ) )
			$hero_brick_query_args['post__in'] = $postin;


		if( !empty( $tagin ) && !is_array( $tagin ) ){
			$temp_tag = explode(',', $tagin );
			$tagin = $temp_tag;
			
		}

		/* Push Specified post to query*/
		if( !empty( $tagin ) && is_array( $tagin ) )
			$hero_brick_query_args['tag__in'] = $tagin;

		/* Push Specified post to query*/
		if( !empty( $exclude_format ) && is_array( $exclude_format ) ){
			$exclude_format_temp = array();
			foreach( $exclude_format as $format ){
				$exclude_format_temp[] = "post-format-$format";
			}

			$hero_brick_query_args['tax_query'] = array(
			    array(
			      'taxonomy' 	=> 'post_format',
			      'field' 		=> 'slug',
			      'terms' 		=> $exclude_format_temp,
			      'operator' 	=> 'NOT IN'
			    )
			);
		}
		/*Allow ordering posts by post views*/ 
		if( 'meta_value_num' == $orderby ){
			$hero_brick_query_args['meta_key'] = apply_filters( 'yt_simple_post_views_tracker_meta_key', '_post_views' );
			$hero_brick_query_args['meta_value_num'] = '0';
			$hero_brick_query_args['meta_compare'] = '>';
		}

		$slider_settings = apply_filters( 'yt_site_hero_banner_carousel_settings', array(
			'selector' => '.slides > li',
			//'directionNav' => false,
			'randomize' => 'true',
			'pausePlay' => false,
			'animationLoop' => false
		) , 'carousel' );


		$hero_post_ids = array();
		
		// print_r($x);
		// die();
		//$hero_query->post_count)

		//print_r($hero_brick_query_args); die();

		/*Init the query, and allow filtering*/
	/*If html == $output_data*/
	//echo yt_pretty_print( $hero_brick_query_args);
	if( $output_data == 'html' ):

		include_once( locate_template('includes/templates/hero-content.php' ) );
		//print_r( $hero_post_ids);

	else:
		$hero_brick_query_args['fields'] = 'ids';
		$hero_post_ids = get_posts( $hero_brick_query_args );
		
	endif;

		wp_reset_postdata();
		$post = $backup_post;

	/*Return hero ids*/
	if( $output_data !== 'html' )
		return $hero_post_ids;

	}
}

/*---------------------------------------------------------------------------------------------------------*
 * Primary content
 *---------------------------------------------------------------------------------------------------------*/

/*
 * Start primary wrapper
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_start_single_row' ) ) {
	 
	function yt_site_start_single_row(){
		echo '
		<div class="container">
			<div class="row">';
	}
}

/*
 * End primary wrapper
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_end_single_row' ) ) {
	 
	function yt_site_end_single_row(){
		
		echo '</div>
		</div>';
	}
}

/**
 * Secondary content
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_secondary_content' ) ) {
	 
	function yt_site_secondary_content(){

		$general_layout = yt_get_options( 'layout' );
		$general_layout = $general_layout ? $general_layout : 'default';
		$conditional = is_page() || ( is_home() && get_option( 'page_for_posts' ) ) || ( yt_is_woocommerce() && wc_get_page_id('shop') ) ;

		/* If is page OR is page for posts ( must set the page for posts in Reading)*/
		if( apply_filters( 'yt_site_secondary_content_conditional', $conditional ) ){
			if( !empty( $GLOBALS['post'] )){
				$post = $GLOBALS['post'];
				$post_id = $post->ID;
			}else{
				$post_id = 0;
			}

			if( is_home() && get_option( 'page_for_posts' ) )
				$post_id = get_option( 'page_for_posts' );

			if( yt_is_woocommerce() && wc_get_page_id('shop') )
				$post_id = wc_get_page_id('shop');

			$post_id = apply_filters( 'yt_site_secondary_content_post_id', $post_id );

			/*Retrieve page layout from meta key*/ 
			$page_layout = get_post_meta( $post_id, 'yt_page_sidebar_layout', true );


			/*Only display secondary sidebar on*/
			if( 'fullwidth' !== $page_layout )
				get_sidebar();
		}else{
			if( 'fullwidth' !== apply_filters( 'yt_site_secondary_content_general_layout', $general_layout ) )
				get_sidebar();
		}
		
	}
}

/**
 * Tertiary content
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_tertiary_content' ) ) {
	 
	function yt_site_tertiary_content(){

		$general_layout = yt_get_options( 'layout' );
		$general_layout = $general_layout ? $general_layout : 'default';
		$conditional = is_page() || ( is_home() && get_option( 'page_for_posts' ) ) || ( yt_is_woocommerce() && wc_get_page_id('shop') ) ;

		/* If is page OR is page for posts ( must set the page for posts in Reading)*/
		if( apply_filters( 'yt_site_tertiary_content_conditional', $conditional ) ){
			if( !empty( $GLOBALS['post'] )){
				$post = $GLOBALS['post'];
				$post_id = $post->ID;
			}else{
				$post_id = 0;
			}
			
			if( is_home() && get_option( 'page_for_posts' ) )
				$post_id = get_option( 'page_for_posts' );

			if( yt_is_woocommerce() && wc_get_page_id('shop') )
				$post_id = wc_get_page_id('shop');

			$post_id = apply_filters( 'yt_site_tertiary_content_post_id', $post_id );

			/*Retrieve page layout from meta key*/ 
			$page_layout = get_post_meta( $post_id, 'yt_page_sidebar_layout', true );
			
			if( !$page_layout )
				$page_layout = $general_layout;

			/*Only display secondary sidebar on*/
			if( in_array( $page_layout, array( 'default', 'double-sidebars' ) ) )
				get_sidebar( 'secondary' );
		}else{
			if( in_array( apply_filters( 'yt_site_tertiary_content_general_layout', $general_layout ), array( 'default', 'double-sidebars' ) ) )
				get_sidebar( 'secondary' );
		}

		
	}
}

add_filter('wp_list_categories', 'yt_site_cat_count_span');

function yt_site_cat_count_span($links) {
	$links = str_replace( 
		array( '</a> (', ')' . "\n" .'</li>' ), 
		array( '</a> <span>(', ')</span></li>' ),
		$links
	);
	return $links;
}

/**
 * After single post content
 *
 * -Author since 1.0.1
 * -Post nav
 * -5 related article
 * -You Might Also Like
 * -Comment
 */

/**
 * Post nav
 *
 * @since 1.0
 */

function yt_site_single_post_author(){
	if( !is_single()  )
		return;

	if( 'hide' == yt_get_options( 'blog_single_post_author_meta') )
		return;


	get_template_part( 'includes/templates/single-author-meta' );
	
}

if ( ! function_exists( 'yt_site_single_post_dir_nav' ) ) {
	function yt_site_single_post_dir_nav(){
		yt_direction_nav( 'nav-below' );
	}
}
/**
 * Single post
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_single_post_related_articles' ) ) {
	 
	function yt_site_single_post_related_articles(){

		if( !is_single() )
			return;

		if( 'hide' == yt_get_options( 'blog_single_post_related_articles') )
			return;




		get_template_part( 'includes/templates/single-related-articles' );
	}
}


/**
 * Single post
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_single_post_you_might_also_like' ) ) {
	 
	function yt_site_single_post_you_might_also_like(){


		if( 'hide' == yt_get_options( 'blog_single_post_youmightalsolike') )
		    return;

		get_template_part( 'includes/templates/single-ymal' );
		
	}
}

/**
 * Post comment
 *
 * @since 1.0
 */	

if ( ! function_exists( 'yt_site_single_post_comment' ) ) {
	 
	function yt_site_single_post_comment(){
		// If comments are open or we have at least one comment, load up the comment template
		if ( 'show' == yt_get_options( 'blog_single_post_comment_template' ) && ( comments_open() || '0' != get_comments_number() ) )
			comments_template();
	}
}
/*---------------------------------------------------------------------------------------------------------*
 * Theme Footer
 *---------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'yt_site_footer' ) ) {
	 
	function yt_site_footer(){



		$footer_layout = yt_get_options('footer_layout');

		if( 'footer-extra' !== $footer_layout && apply_filters( 'yt_site_footer_widgets', true  ) ):
			
			get_template_part( 'includes/templates/footer-widgets' );
		endif;

		if( 'footer-widget' !== $footer_layout && ( yt_get_options('footer_text_left') || yt_get_options('footer_text_right'))  && apply_filters( 'yt_site_footer_info', true  ) ):


			get_template_part( 'includes/templates/footer-info' );
		endif;
	}
}


/*---------------------------------------------------------------------------------------------------------*
 * Theme ads
 *---------------------------------------------------------------------------------------------------------*/

/**
 * Head Ads
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_head_ads' ) ) {
	
	function yt_site_head_ads(){
		
		
		if( !empty( $GLOBALS['post'] )){
			$post = $GLOBALS['post'];
			$post_id = $post->ID;
		}else{
			$post_id = 0;
		}
		
		if( yt_get_options( 'site_ads_after_header' ) ):
			$output = sprintf('<div class="site-head-ads clearfix border-bottom">
				<div class="container site-head-ads text-center padding-top-30 padding-bottom-30 clearfix">
				%s
				</div>
			</div>', yt_get_options( 'site_ads_after_header' ));

			echo do_shortcode( apply_filters( 'yt_site_head_ads', $output, $post_id ) );
		endif;
	}
}

/**
 * Foot Ads
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_foot_ads' ) ) {
	
	function yt_site_foot_ads(){

		if( !empty( $GLOBALS['post'] )){
			$post = $GLOBALS['post'];
			$post_id = $post->ID;
		}else{
			$post_id = 0;
		}

		if( yt_get_options( 'site_ads_before_footer' ) ):
			$output = sprintf('<div class="site-head-ads clearfix border-top">
				<div class="container site-head-ads text-center padding-top-30 padding-bottom-30 clearfix">
				%s
				</div>
			</div>', yt_get_options( 'site_ads_before_footer' ) );
			echo do_shortcode( apply_filters( 'yt_site_foot_ads', $output, $post_id ) );
		endif;
	}
}

/**
 * Single post ads
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_ads_between_rlpaymasl_single_post' ) ) {
	function yt_site_ads_between_rlpaymasl_single_post(){

		$condition = is_singular( 'post' );
		if( !apply_filters( 'yt_site_ads_between_rlpaymasl_single_post_condition', $condition ) )
			return;

		if( !empty( $GLOBALS['post'] )){
			$post = $GLOBALS['post'];
			$post_id = $post->ID;
		}else{
			$post_id = 0;
		}

		if( yt_get_options( 'site_ads_between_rlpaymasl_single_post' ) ):
			$output = '<div class="entry-stuff clear margin-bottom-30 hidden-print text-center">';
			$output .= stripslashes( yt_get_options( 'site_ads_between_rlpaymasl_single_post' ) );
			$output .= '</div>';
			echo do_shortcode( apply_filters( 'yt_site_ads_between_rlpaymasl_single_post', $output, $post_id ) );
		endif;
		
	}
}
 

 
/*---------------------------------------------------------------------------------------------------------*
 * Theme sections's classes
 * 
 * Adding classes for Sections
 *---------------------------------------------------------------------------------------------------------*/


/*
 * Primary Class
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_primary_class' ) ) {
	 
	function yt_site_primary_class($_classes){
		
		$theme_layouts = array(
			'default', 
			'right-sidebar',
			'left-sidebar',
			'fullwidth',
			'double-sidebars'
		);

		$general_layout = yt_get_options( 'layout' );
		$general_layout = in_array( $general_layout, $theme_layouts ) ? $general_layout : 'default';
		$page_layout = $general_layout;
		$conditional = is_page() || ( is_home() && get_option( 'page_for_posts' ) ) || ( yt_is_woocommerce() && wc_get_page_id('shop') ) ;
		
		/* If is page OR is page for posts ( must set the page for posts in Reading)*/
		if( apply_filters( 'yt_site_primary_class_conditional', $conditional ) ){
			if( !empty( $GLOBALS['post'] )){
				$post = $GLOBALS['post'];
				$post_id = $post->ID;
			}else{
				$post_id = 0;
			}
			
			if( is_home() && get_option( 'page_for_posts' ) )
				$post_id = get_option( 'page_for_posts' );

			if( yt_is_woocommerce() && wc_get_page_id('shop') ){
				$post_id = wc_get_page_id('shop');
			}

			/*Retrieve page layout from meta key*/ 
			$page_layout = get_post_meta( $post_id, 'yt_page_sidebar_layout', true );
			
			if( !$page_layout )
				$page_layout = $general_layout;
		}
		
		$page_layout = apply_filters( 'yt_site_page_layout_primary', $page_layout );

		$classes = array();

		if( 'default' == $page_layout ){

			$classes[] = 'col-sm-12';
			//$classes[] = 'col-sm-push-3';
			
			$classes[] = 'col-md-7';
			$classes[] = 'col-md-push-2';
			
			$classes[] = 'col-lg-7';
			$classes[] = 'col-lg-push-2';

			$classes[] = 'boundary-column';

		}elseif( 'double-sidebars' == $page_layout ){

			$classes[] = 'col-sm-12';
			$classes[] = 'col-md-6';

		}elseif( 'right-sidebar' == $page_layout ){

			$classes[] = 'col-sm-12';
			$classes[] = 'col-md-8';

		}elseif( 'left-sidebar' == $page_layout ){

			$classes[] = 'col-sm-12';
			$classes[] = 'col-md-8';
			$classes[] = 'col-md-push-4';

		}elseif( 'fullwidth' == $page_layout ){

			$classes[] = 'col-sm-12';
		}else{


			$classes = apply_filters( 'yt_site_primary_classes_custom_layout', $classes, $page_layout );
		}

		$classes[] = 'printable-section';
		//$classes[] = 'fadeIn animated';
		
		$classes = apply_filters( 'yt_site_primary_classes', $classes );
		
		$_classes = array_merge( $_classes, $classes );

		return $_classes;
	}
}

/*
 * Secondary Class
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_secondary_class' ) ) {
	 
	function yt_site_secondary_class($_classes){

		$theme_layouts = array(
			'default', 
			'right-sidebar',
			'left-sidebar',
			'fullwidth',
			'double-sidebars'
		);

		$general_layout = yt_get_options( 'layout' );
		$general_layout = in_array( $general_layout, $theme_layouts ) ? $general_layout : 'default';
		$page_layout = $general_layout;
		$conditional = is_page() || ( is_home() && get_option( 'page_for_posts' ) ) || ( yt_is_woocommerce() && wc_get_page_id('shop') ) ;
		
		/* If is page OR is page for posts ( must set the page for posts in Reading)*/
		if( apply_filters( 'yt_site_secondary_class_conditional', $conditional ) ){
			if( !empty( $GLOBALS['post'] )){
				$post = $GLOBALS['post'];
				$post_id = $post->ID;
			}else{
				$post_id = 0;
			}

			if( is_home() && get_option( 'page_for_posts' ) )
				$post_id = get_option( 'page_for_posts' );

			if( yt_is_woocommerce() && wc_get_page_id('shop') )
				$post_id = wc_get_page_id('shop');

			/*Retrieve page layout from meta key*/ 
			$page_layout = get_post_meta( $post_id, 'yt_page_sidebar_layout', true );
			
			if( !$page_layout )
				$page_layout = $general_layout;
		}

		$page_layout = apply_filters( 'yt_site_page_layout_secondary', $page_layout );

		$classes = array();

		if( 'default' == $page_layout ){
			if( 'hide' == yt_get_options( 'site_page_main_sidebar' ) ){
				$classes[] = 'hidden-xs';
				$classes[] = 'hidden-sm';
			}else{


				$classes[] = 'col-sm-6';
			}
			

			$classes[] = 'col-md-3';
			$classes[] = 'col-md-push-2';
			
			$classes[] = 'col-lg-3';
			$classes[] = 'col-lg-push-2';

		}elseif( 'double-sidebars' == $page_layout ){

			if( 'hide' == yt_get_options( 'site_page_main_sidebar' ) ){
				$classes[] = 'hidden-xs';
				$classes[] = 'hidden-sm';

			}else{

				$classes[] = 'col-sm-6';
			}
			
			$classes[] = 'col-md-3';
			$classes[] = 'col-md-push-3';
			
			$classes[] = 'col-lg-3';
			$classes[] = 'col-lg-push-3';

		}elseif( 'right-sidebar' == $page_layout ){

			if( 'hide' == yt_get_options( 'site_page_main_sidebar' ) ){
				$classes[] = 'hidden-xs';

				$classes[] = 'col-sm-12';
				$classes[] = 'hidden-sm';
			}else{

				$classes[] = 'col-sm-12';
			}
			
			$classes[] = 'col-md-4';
			$classes[] = 'boundary-column';

		}elseif( 'left-sidebar' == $page_layout ){

			if( 'hide' == yt_get_options( 'site_page_main_sidebar' ) ){
				$classes[] = 'hidden-xs';

				$classes[] = 'col-sm-12';
				$classes[] = 'hidden-sm';
			}else{
				
				$classes[] = 'col-sm-12';
			}

			$classes[] = 'col-md-4';
			$classes[] = 'col-md-pull-8';
			$classes[] = 'boundary-column';

		}else{
			$classes = apply_filters( 'yt_site_secondary_classes_custom_layout', $classes, $page_layout );
		}

		$classes[] = 'hidden-print';
		//$classes[] = 'fadeIn animated';
		
		$classes = apply_filters( 'yt_site_secondary_classes', $classes );
		
		$_classes = array_merge( $_classes, $classes );

		return $_classes;
	}
}
/*
 * Tertiary Class
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_tertiary_class' ) ) {
	 
	function yt_site_tertiary_class($_classes){

		$theme_layouts = array(
			'default', 
			'right-sidebar',
			'left-sidebar',
			'fullwidth',
			'double-sidebars'
		);

		$general_layout = yt_get_options( 'layout' );
		$general_layout = in_array( $general_layout, $theme_layouts ) ? $general_layout : 'default';
		$page_layout = $general_layout;		
		$conditional = is_page() || ( is_home() && get_option( 'page_for_posts' ) ) || ( yt_is_woocommerce() && wc_get_page_id('shop') ) ;
		
		/* If is page OR is page for posts ( must set the page for posts in Reading)*/
		if( apply_filters( 'yt_site_tertiary_class_conditional', $conditional ) ){
			if( !empty( $GLOBALS['post'] )){
				$post = $GLOBALS['post'];
				$post_id = $post->ID;
			}else{
				$post_id = 0;
			}
			
			if( is_home() && get_option( 'page_for_posts' ) )
				$post_id = get_option( 'page_for_posts' );

			if( yt_is_woocommerce() && wc_get_page_id('shop') )
				$post_id = wc_get_page_id('shop');

			/*Retrieve page layout from meta key*/ 
			$page_layout = get_post_meta( $post_id, 'yt_page_sidebar_layout', true );
			
			if( !$page_layout )
				$page_layout = $general_layout;
		}

		$page_layout = apply_filters( 'yt_site_page_layout_tertiary', $page_layout );
		$classes = array();
		if( 'default' == $page_layout ){


			if( 'hide' == yt_get_options( 'site_page_sub_sidebar' ) ){
				$classes[] = 'hidden-xs';
				$classes[] = 'hidden-sm';
			}else{
				$classes[] = 'col-sm-6';
			}
			
			$classes[] = 'col-md-2';
			$classes[] = 'col-md-pull-10';
			
			$classes[] = 'col-lg-2';
			$classes[] = 'col-lg-pull-10';

		}elseif( 'double-sidebars' == $page_layout ){

			if( 'hide' == yt_get_options( 'site_page_sub_sidebar' ) ){
				$classes[] = 'hidden-xs';
				$classes[] = 'hidden-sm';
			}else{
				$classes[] = 'col-sm-6';
			}
			
			$classes[] = 'col-md-3';	
			$classes[] = 'col-md-pull-3';
			
			$classes[] = 'col-lg-3';
			$classes[] = 'col-lg-pull-3';
			$classes[] = 'boundary-column';

		}else{

			$classes = apply_filters( 'yt_site_tertiary_classes_custom_layout', $classes, $page_layout );

		}
		
		$classes[] = 'hidden-print';
		//$classes[] = 'fadeIn animated';

		$classes = apply_filters( 'yt_site_tertiary_classes', $classes );

		$_classes = array_merge( $_classes, $classes );

		return $_classes;
	}
}
/*
 * Content Class
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_content_class' ) ) {
	 
	function yt_site_content_class($_classes){
		
		if( !is_home() && !is_page() )
			return $_classes;

		global $post;

		$post_id = $post->ID;

		if( is_home() && is_main_query() && get_option('page_for_posts' ) ){

			$post_id = $post->ID = get_option('page_for_posts' );
		}


		$layout = get_post_meta( $post_id, 'yt_page_queryposts_layout', true );
		$query_post_mode = get_post_meta( $post_id, 'yt_page_queryposts_mode', true); 

		if( $query_post_mode && $layout ){
			$_classes[] = "post-layout-$layout";
		}

			
		return $_classes;
	}
}

/*
 * Footer Class
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_footer_class' ) ) {
	 
	function yt_site_footer_class($_classes){

		$classes = array();
		
		$classes[] = 'full-width-wrapper';
		$classes[] = 'hidden-print';
		
		$classes = apply_filters( 'yt_site_footer_classes', $classes );
		
		$_classes = array_merge( $_classes, $classes );

		return $_classes;
	}
}

/*
 * Header Class
 *
 * @since 1.0
 */
if ( ! function_exists( 'yt_site_header_class' ) ) {
	 
	function yt_site_header_class($_classes){

		$classes = array();
		
		$classes[] = 'full-width-wrapper';

		$classes[] = 'hidden-print';
		
		$classes = apply_filters( 'yt_site_header_classes', $classes );
		
		$_classes = array_merge( $_classes, $classes );

		return $_classes;
	}
}

if ( ! function_exists( 'yt_site_wrapper_class' ) ) {
	 
	function yt_site_wrapper_class($classes){
		
		$classes[] = 'full-width-wrapper';
		
		return $classes;
	}
}

//add_filter( 'yt_wrapper_attribute','yt_site_wrapper_attr');

if ( ! function_exists( 'yt_site_wrapper_attr' ) ) {
	 
	function yt_site_wrapper_attr($attr){
		
		$attr .= ' data-general="hahahah"';
		
		return $attr;
	}
}

//add_filter( 'yt_home_wrapper_attribute','yt_site_home_wrapper_attr');

if ( ! function_exists( 'yt_site_home_wrapper_attr' ) ) {
	 
	function yt_site_home_wrapper_attr($attr){
		
		$attr .= ' data-home-wrapper=""';
		
		return $attr;
	}
}

/*
 * Overwrite Impressive like Plugin settings
 *
 * @since 1.0
 * @framework 1.0
 */

add_filter( 'yt_impressive_like_symbol', 'yt_site_impressive_like_symbol');

if( !function_exists( 'yt_site_impressive_like_symbol') ) {
	
	function yt_site_impressive_like_symbol(){
		return '<i class="fa fa-heart"></i>';
	}
}

add_filter( 'yt_icon_next_post', 'yt_site_icon_next_post');

if( !function_exists( 'yt_site_icon_next_post') ) {
	
	function yt_site_icon_next_post(){
		return '<span class="btn btn-default"><i class="fa fa-chevron-right"></i></span>';
	}
}

add_filter( 'yt_icon_prev_post', 'yt_site_icon_prev_post');

if( !function_exists( 'yt_site_icon_prev_post') ) {
	
	function yt_site_icon_prev_post(){
		return '<span class="btn btn-default"><i class="fa fa-chevron-left"></i></span>';
	}
}





//add_filter( 'widget_title', 'yt_widget_title_icon', 10,3 );
/**
 * Icon for widget title
 *
 * @since 1.0.4
 */

function yt_widget_title_icon( $title, $instance, $id_base ) {
    if( 'search' == $id_base)
    	return '<i class="fa fa-search"></i> ' . $title;

	return $title;
}

/**
 * Single post ads
 *
 * @since 1.0.4
 */

if ( ! function_exists( 'yt_site_ads_before_single_post' ) ) {
	function yt_site_ads_before_single_post( $content){

		$condition = is_singular( 'post' );
		if( !apply_filters( 'yt_site_ads_before_single_post_condition', $condition ) )
			return $content;

		if( !empty( $GLOBALS['post'] )){
			$post = $GLOBALS['post'];
			$post_id = $post->ID;
		}else{
			$post_id = 0;
		}
		$ads = yt_get_options( 'site_ads_before_single_post' );
		$output = '';
		if( $ads ):
			$output = '<div class="entry-stuff margin-bottom-15 hidden-print single-post-ads-top pull-right-sm pull-right-md pull-right-lg margin-left-15 text-center-xs">';
			$output .= stripslashes( $ads );
			$output .= '</div>';
			$output = do_shortcode( apply_filters( 'yt_site_ads_before_single_post', $output, $post_id ) );
		endif;

		return $output . $content;
		
	}
}
/**
 * Single post ads
 *
 * @since 1.0.4
 */
if ( ! function_exists( 'yt_site_ads_between_single_post' ) ) {
	function yt_site_ads_between_single_post( $content ){

		$condition = is_singular( 'post' );
		if( !apply_filters( 'yt_site_ads_between_single_post_condition', $condition ) )
			return $content;

		if( !empty( $GLOBALS['post'] )){
			$post = $GLOBALS['post'];
			$post_id = $post->ID;
		}else{
			$post_id = 0;
		}

		$ads = yt_get_options( 'site_ads_between_single_post' );
		if( empty( $ads ))
			return $content;

		$ads = '<div class="entry-stuff clear margin-bottom-15 hidden-print single-post-ads-between center-block text-center">' . stripslashes( $ads ) . '</div>';
		$ads = do_shortcode( apply_filters( 'yt_site_ads_between_single_post', $ads, $post_id ) );

		$delimeter = '</p>';
		$linebreaks = substr_count( $content, $delimeter );
		
		if( $linebreaks < apply_filters( 'yt_site_ads_between_single_post_paragraph_count', 3 ) )
			return $content;

		$insert_after = intval( $linebreaks/2 ) + 1;

		$paragraphs = explode( $delimeter, $content );

		foreach ($paragraphs as $key => $paragraph) {
			if ( trim( $paragraph ) ) {
				$paragraphs[$key] .= $delimeter;
			}
			if ( $insert_after == $key + 1 ) {
	            $paragraphs[$key] .= $ads;
	        }
		}		

		return implode( '', $paragraphs );
	}
}
/**
 * Single post ads
 *
 * @since 1.0
 */

if ( ! function_exists( 'yt_site_ads_after_single_post' ) ) {
	function yt_site_ads_after_single_post( $content ){

		$condition = is_singular( 'post' );
		if( !apply_filters( 'yt_site_ads_before_single_post_condition', $condition ) )
			return $content;

		if( !empty( $GLOBALS['post'] )){
			$post = $GLOBALS['post'];
			$post_id = $post->ID;
		}else{
			$post_id = 0;
		}

		$ads = yt_get_options( 'site_ads_after_single_post' );
		$output = '';
		if( $ads ):
			$output = '<div class="entry-stuff clear margin-bottom-15 hidden-print single-post-ads-bottom text-center">';
			$output .= stripslashes( $ads );
			$output .= '</div>';
			$output = do_shortcode( apply_filters( 'yt_site_ads_after_single_post', $output, $post_id ) );
		endif;

		return $content . $output;
		

	}
}

/**
 * Modal search
 * @since 1.0.4
 */
if( !function_exists( 'yt_site_modal_search_box' )){
	function yt_site_modal_search_box(){

		if( 'modal' != yt_get_options('site_search_type') )
			return;

		get_template_part( 'includes/templates/modal-search' );
	}
}

/*
 * Color bar & Breaking news
 * @since 1.0.4
 */
if ( ! function_exists( 'yt_site_breaking_news' ) ) {
	
	function yt_site_breaking_news(){

		if(!yt_get_options('site_news_tickers_mode'))
			return;

		
		get_template_part( 'includes/templates/site-newsticker' );
	}
}
/*
 * Top category link for entry 
 * @since 1.0.4
 */
if(!function_exists( 'yt_site_post_entry_category' )){
	function yt_site_post_entry_category(){

		$meta_info = yt_get_options('blog_post_meta_info');

		if( !in_array( 'category',$meta_info ) ) 
			return;
		
		//Category
		$categories = get_the_category();
		$categories_output = array();
		
		if($categories){
			foreach($categories as $category) {
				$categories_output[] = '<a class="'.$category->slug.'" href="'. get_category_link( $category->term_id ).'" title="' . esc_attr( sprintf( __( 'View all posts in %s', 'yeahthemes' ), $category->name ) ) . '">'.$category->cat_name.'</a>';
			}
		}
		echo '<strong class="text-uppercase margin-bottom-15 display-block">'. join( ', ', $categories_output ) . '</strong>';
	}
}
/*
 * Style 2 of post meta description
 * @since 1.0.4
 */
if( !function_exists('yt_site_impressive_post_meta_description')){
	function yt_site_impressive_post_meta_description(){

		global $post;

		if ( isset($post->post_type ) && 'post' !== $post->post_type ){
			return;
		}
		get_template_part( 'includes/templates/post-meta-desc-alt' );
		
	}
}