<?php
// This file is not called from WordPress. We don't like that.
! defined( 'ABSPATH' ) and exit;

/**
 **********************************************************************************************************
 * 												DO NOT EDIT THIS FILE
 **********************************************************************************************************
 * Theme Options
 *
 * @author		Yeahthemes
 * @copyright	Copyright ( c ) Yeahthemes
 * @link		http://yeahthemes.com
 * @since		Version 1.0
 * @package 	Yeah Includes
 */

if( !function_exists( 'yt_theme_options' ) ) {
	
	function yt_theme_options() {
		
		$yt_data = yt_get_options();
		
		$on_off = array(
			'on' => __('ON', 'yeahthemes'), 
			'off' => __('OFF', 'yeahthemes')
		);
		$show_hide = array(
			'show' => __('Show', 'yeahthemes'), 
			'hide' => __('Hide', 'yeahthemes')
		);
		
		/* Font faces */
		$fontfaces = yt_get_option_vars( 'fontfaces' );
		// Yes/No
			
		$yes_no = array('1' => __('Yes', 'yeahthemes'), '0' => __('No', 'yeahthemes'));
		
		//
		$enable_disable = array(
			'enable' => __('Enable', 'yeahthemes'), 
			'disable' => __('Disable', 'yeahthemes')
		);
		
		// True/False
		$true_false = array(
			'true' => __('True', 'yeahthemes'), 
			'false' => __('False', 'yeahthemes')
		);		
		
		//$yt_subscription_form = array('file' => __('Save to .CSV file','yeahthemes'), 'mailchimp' => 'MailChimp', 'feedburner' => 'FeedBurner');
			
		//Background Images Reader
		$bg_images_path = yt_get_overwritable_directory( '/images/bg/' ); // change this to where you store your bg images
		$bg_images_url = yt_get_overwritable_directory_uri( '/images/bg/' ) ; // change this to where you store your bg images
		
		
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
			if ($bg_images_dir = opendir($bg_images_path) ) { 
				while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
					if(stristr($bg_images_file, '.png') !== false || stristr($bg_images_file, '.jpg') !== false) {
						$bg_images[] = $bg_images_url . $bg_images_file;
					}
				}    
			}
		}
		
		//print_r($bg_images);
		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr = wp_upload_dir();
		$all_uploads_path = $uploads_arr['path'];
		$all_uploads = get_option('yt_uploads');
		$other_entries = array('Select a number:','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19');
		$body_repeat = array('no-repeat','repeat-x','repeat-y','repeat');
		$body_pos = array('top left','top center','top right','center left','center center','center right','bottom left','bottom center','bottom right');
		
		// Image Alignment radio box
		$yt_options_thumb_align = array('alignleft' => 'Left','alignright' => 'Right','aligncenter' => 'Center'); 
				
		$url =  YEAHTHEMES_FRAMEWORK_URI . 'admin/assets/images/';	
		
		$yt_options = array();
		
		/**
		 * General Settings
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_generalsettings', array(	
			array( 
				'name' => __('General Settings','yeahthemes'),
				'desc' => __('Logo, Email, Copyright ,Contact/Branding informations ...','yeahthemes'),
				'type' => 'heading',
				'customize' => 1,
				'settings' => array(
					'icon' => 'generalsettings'
				)
				
			),
			array( 
				'name' => __('Plain Text Logo','yeahthemes'),
				'desc' => sprintf(__('You can change site title and site tagline in <a href="%s">%s</a>','yeahthemes'), admin_url( 'options-general.php' ), __('Settings -> General', 'yeahthemes' ) ),
				'id' => 'plain_logo',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'customize' => 1,
				'settings' => array(
					'folds' => '0',
					'label' => __('Toggle this to enable a plain text logo rather than an image.','yeahthemes'),
				)
			),
			array( 
				'name' => __('Custom Logo','yeahthemes'),
				'desc' => __('Upload a logo for your theme, or specify the image address of your online logo. (http://example.com/logo.png) <br>Dimension: 250px for width and 100px for height (if you use short banner it will be 80px).','yeahthemes'),
				'id' => 'logo',
				'std' => YEAHTHEMES_URI . 'images/logo.png',
				'type' => 'media',
				'customize' => 1,
				'settings' => array(
					'sanitize' => 'esc_url',
				)
			),
		) ) ); 
			
		/**
		 * Post types Setting
		 */
		// $yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_posttypesettings', array(	
		// 	array( 
		// 		'name' => __('Post type settings','yeahthemes'),
		// 		'type' => 'heading',
		// 		'customize' => 1,
		// 		'settings' => array(
		// 			'icon' => 'posttypesettings'
		// 		)
		// 	),
		// ) ) );
		
		
		$url =  YEAHTHEMES_FRAMEWORK_URI . 'admin/assets/images/';	
		/**
		 * Interface Settings
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_interfacesettings', array(	
			
			array( 
				'name' => __('Interface Settings','yeahthemes'),
				'type' => 'heading',
				'desc' => __('Configure appearance of elements on the the site (eg: disable Responsiveness or change footer layout)','yeahthemes'),
				'customize' => 1,
				'settings' => array(
					'icon' => 'interfacesettings'
				)
			),
		) ) );

		/**
		 * Interface Settings - overall
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_interfacesettings_overall', array(
			array( 
				'type' => 'subheading',
				'name' => __('Overall','yeahthemes'),
				'customize' => 1,
				'customize_name' => __('Interface Settings - Overall','yeahthemes'),
			),
			array( 
				'name' => __('Boxed layout','yeahthemes'),
				'desc' => '',
				'id' => 'site_boxed_layout_mode',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'customize' => 1,
				'settings' => array(
					'label' => __('Toggle this to enable boxed layout (narrow width).','yeahthemes'),
				)
			),
			array( 
				'name' => __('Large display layout','yeahthemes'),
				'desc' => __('1200px and up','yeahthemes'),
				'id' => 'site_width_large_mode',
				'std' => 0,
				'type' => 'checkbox',	
				'class' => 'yt-section-toggle-checkbox',
				'customize' => 1,
				'settings' => array(
					'label' => __('Toggle this to enable wide layout for large display.', 'yeahthemes'),
				)
			),
			array( 
				'name' => __('Default Layout','yeahthemes'),
				'desc' => __('Select main content and sidebar alignment.','yeahthemes'),
				'id' => 'layout',
				'std' => 'default',
				'type' => 'columns',
				'options' => apply_filters( 'yt_theme_options_option_general_site_layout' ,array(
					'default' => 'default',
					'left-sidebar' => '4+8',
					'fullwidth' => '12',
					'right-sidebar' => '8+4',
				) )
				
			),
			array( 
				'name' => __('Page comment box','yeahthemes'),
				'desc' => '',
				'id' => 'site_page_comment_mode',
				'std' => 0,
				'type' => 'checkbox',	
				'class' => 'yt-section-toggle-checkbox',
				'customize' => 1,
				'settings' => array(
					'label' => __('Toggle this to enable Page comment box.', 'yeahthemes'),
				)
			),
			array(
				'type' => 'separator',
				'name' => __('Sidebars on Small screens','yeahthemes'),
			),
			array(
				'name' => __('Main sidebar','yeahthemes'),
				'desc' => __('Show/hide sidebar on Small screen sizes.','yeahthemes'),
				'id' => 'site_page_main_sidebar',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,

				'customize' => 1,
			),
			array(
				'name' => __('Sub sidebar','yeahthemes'),
				'desc' => __('Show/hide sidebar on Small screen sizes.','yeahthemes'),
				'id' => 'site_page_sub_sidebar',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,

				'customize' => 1,
			),
		) ) );
		
		/**
		 * Interface Settings - Header
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_interfacesettings_header', array(	
			array(
				'name' => __('Header','yeahthemes'),
				'type' => 'subheading',
				'customize' => 1,
				'customize_name' => __('Interface Settings - Header','yeahthemes')
			),array(
				'name' => __('Top bar menu','yeahthemes'),
				'desc' => '',
				'id' => 'header_top_bar_menu',
				'std' => 'hide',
				'type' => 'toggles',
				'options' => $show_hide
			),array( 
				'name' => __('Scrollfix Main menu','yeahthemes'),
				'desc' => '',
				'id' => 'header_scrollfix_mainmenu',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'customize' => 1,
				'settings' => array(
					'label' => __('Toggle this to enable Scrollfix Main menu style.','yeahthemes'),
				)
			),array(
				'name' => __('News Mega Request type','yeahthemes'),
				'desc' => __('Choose the method of retrieving posts when hover to News mega menu<br>-Ajax request: Used Ajax technique to load posts when hover<br>-Regular request: loads posts instantly when hover. (this might affect to loading speed if you have many loop on a page, we recommend you to use cache plugin to reduce server response time)','yeahthemes'),
				'id' => 'main_megamenu_request_type',
				'std' => 'regular',
				'type' => 'select',
				'customize' => 1,
				'options' => array(
					'ajax' => __('Ajax request', 'yeahthemes'),
					'regular' => __('Regular request', 'yeahthemes'),
				)
			),array(
				'name' => __('Social links Position','yeahthemes'),
				'desc' => '',
				'id' => 'header_social_links_position',
				'std' => 'hide',
				'type' => 'select',
				'customize' => 1,
				'options' => array(
					'hide' => __('Hide', 'yeahthemes'),
					'top_menu' => __('Top Menu bar', 'yeahthemes'),
					'main_menu' => __('Main Menu bar', 'yeahthemes'),
				)
			),
			array(
				'name' => __('Site Search box type','yeahthemes'),
				'desc' => '',
				'id' => 'site_search_type',
				'std' => 'modal',
				'type' => 'select',
				'customize' => 1,
				'options' => array(
					'default' => __('Defaul (dropdown)', 'yeahthemes'),
					'modal' => __('Open in Modal box', 'yeahthemes'),
				),
				'settings' => array(
					'folds' => '0',
				)
			),
			array( 
				'name' => __('Modal search box type', 'yeahthemes'),
				'desc' => '',
				'id' => 'site_modal_search_request_type',
				'std' => 'regular',
				'type' => 'select',
				'settings' => array(
					'fold' => 'site_search_type',
					'fold_value' => 'modal',
				),
				'options' => array(
					'ajax' => __('Ajax request', 'yeahthemes'),
					'regular' => __('Regular request', 'yeahthemes'),
				)	
			),
			array( 
				'name' => __('Site News Ticker','yeahthemes'),
				'desc' => '',
				'id' => 'site_news_tickers_mode',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'customize' => 1,
				'settings' => array(
					'folds' => '0',
					'label' => __('Toggle this to enable News Tickes (aka. Breaking News in Demo)','yeahthemes'),
				)
			),
			array( 
				'name' => __('Site News Ticker Title','yeahthemes'),
				'desc' => '',
				'id' => 'site_news_tickers_title',
				'std' => 'Breaking News',
				'type' => 'text',
				'customize' => 1,
				'settings' => array(
					'fold' => 'site_news_tickers_mode',
				)
			),
			array(
				'name' => __('Site News Ticker Query','yeahthemes'),
				'desc' => '',
				'id' => 'site_news_tickers_query_posts',
				'std' => '',
				'type' => 'group_options',
				'customize' => 0,
				'options' => array(
					array(
						'name' => __('Categories','yeahthemes'),
						'id' => 'cat',
						'type' => 'tag_search',
						'std' => '',
						'desc' => __('Keep typing and you will be suggested','yeahthemes'),
						'settings' => array(
							'tax' => 'category'
						)
					),
					array(
						'name' => __('Tags','yeahthemes'),
						'id' => 'tag',				
						'type' => 'tag_search',
						'std' => '',
						'desc' => __('Keep typing and you will be suggested','yeahthemes'),
					),
					array(
						'name' => __('Order','yeahthemes'),
						'id' => 'order',						
						'type' => 'select',
						'std' => 'DESC',
						'desc' => __('Keep typing and you will be suggested','yeahthemes'),
						'options' => array(
							'DESC' 		=> __( 'Descending', 'yeahthemes' ),
							'ASC' 		=> __( 'Ascending', 'yeahthemes' ),
						)
					),
					array(
						'name' => __('Order by','yeahthemes'),
						'id' => 'orderby',
						'std' => 'DESC',
						'type' => 'select',
						'options' => array(
							'date' 		=> __( 'Date', 'yeahthemes' ),
							'title' 	=> __( 'Title', 'yeahthemes' ),
							'name' 		=> __( 'Post slug', 'yeahthemes' ),
							'author' 	=> __( 'Author', 'yeahthemes' ),
							'modified' => __( 'Last modified date', 'yeahthemes' ),
							'comment_count' => __( 'Number of comments', 'yeahthemes' ),
							'rand' 		=> __( 'Random order', 'yeahthemes' ),
							'meta_value_num' => __( 'Post Views', 'yeahthemes' ),
						)
					),
					array(
						'name' => __('Number of Posts','yeahthemes'),
						'id' => 'posts_per_page',						
						'type' => 'number',
						'std' => 10
					),
					array(
						'name' => __('Exclude post format','yeahthemes'),
						'id' => 'excludeformat',						
						'type' => 'multicheck',
						'std' => array(),
						'options' => yt_get_supported_post_formats(),
						'settings' => array(
							'is_indexed' => 1
						)
					),

				),
				'settings' => array(
					'fold' => 'site_news_tickers_mode',
				)
			)

		) ) ); 

		/**
		 * Interface Settings - footer
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_interfacesettings_footer', array(	
			array( 
				'type' => 'subheading',
				'name' => __('Footer','yeahthemes'),
				'customize' => 1,
				'customize_name' => __('Interface Settings - Footer','yeahthemes'),
			),
			array( 
				'name' => __('Footer Layout','yeahthemes'),
				'desc' => __('Select a footer layout style. (full, half, small)','yeahthemes'),
				'id' => 'footer_layout',
				'std' => 'footer-extra',
				'type' => 'columns',
				'options' => array(
					'footer-full-layout' => '9+3',
					'footer-widget' => '9',
					'footer-extra' => '3'
				),
				'customize' => 1,
				'settings' =>  array(
					 'direction' => 'horizontal'
				),
				
			),
			array( 
				'name' => __('Footer Columns','yeahthemes'),
				'desc' => __('Select the number of columns you would like to display in the footer.','yeahthemes'),
				'id' => 'footer_columns',
				'std' => 'col-sm-3_col-sm-3_col-sm-3_col-sm-3',
				'type' => 'columns',
				'options' => yt_get_option_vars( 'footer_columns' ),
				'customize' => 1,
				'settings' =>  array(),
			),
			array( 
				'name' => __('Left Footer credit','yeahthemes'),
				'id' => 'footer_text_left',
				'std' => '&copy; ' . date("Y") . ' <a href="http://' . 'yeahthemes.com" title="Everything you need to create a trendy, uniquely beautiful website without any of coding knowledge">Yeahthemes</a>. All Rights Reserved. Powered by <a href="http://wordpress.org">WordPress</a>.',
				'type' => 'textarea',
				'customize' => 1,
			),
			array( 
				'name' => __('Right Footer credit','yeahthemes'),
				'id' => 'footer_text_right',
				'std' => '<a href="#masthead" class="back-to-top">Back to top</a>',
				'type' => 'textarea',
				'customize' => 1,
			)
		) ) );
				 
		/**
		 * Blog Settings
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_blogsettings', array(
			array( 
				'name' => __('Blog Settings','yeahthemes'),
				'type' => 'heading',
				'desc' => __('Configure parameters for default blog page','yeahthemes'),
				'customize' => 1,
				'settings' => array(
					'icon' => 'blogsettings'
				)
			),
		) ) );
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_blogsettings_general', array(
			array(
				'type' => 'subheading',
				'name' => __('General','yeahthemes'),
				'customize' => 1,
				'customize_name' => __('Blog Settings - General','yeahthemes'),
			),
			array(
				'name' => __('Exclude Categories from Default Blog page (Page for posts)','yeahthemes'),
				'desc' => __('Check the categories that you don\'t want to display in main blog page (page for posts)','yeahthemes'),
				'id' => 'mainblog_exclude_cats',
				'std' => array(),
				'type' => 'category_checklist',
			),
			array(
				'name' => __('Excerpt output','yeahthemes'),
				'desc' => __('Handle output of excerpt content:<br>-Manual: Use <--more--> tag to split a first part of post content and use it as summary on main archive page.<br>-Automatic: Split your content automatically.','yeahthemes'),
				'id' => 'excerpt_output',
				'std' => 'manual',
				'type' => 'select',
				'options' => array(
					'manual' => __('Manual','yeahthemes'),
					'automatic' => __('Automatic','yeahthemes'),
				),
			),
			array(
				'name' => __('Excerpt length','yeahthemes'),
				'desc' => __('Change excerpt length to display in blog page. (default is 55 words), only apply when you handle excerpt manually.','yeahthemes'),
				'id' => 'custom_excerpt_length',
				'std' => 55,
				'type' => 'uislider',
				'settings' => array(
					'min' => 10,
					'max' => 300,
					'step' => 5,
					'unit' => 'w',
				)
			),
			array(
				'name' => __('Pagination','yeahthemes'),
				'desc' => __('Select the Pagination type for blog archive page','yeahthemes'),
				'id' => 'blog_pagination',
				'std' => 'number',
				'type' => 'select',
				'customize' => 1,
				'options' => array(
					'number' => __('Numeric Pagination','yeahthemes'), 
					'direction' => __('Next/Prev links','yeahthemes')
				)	
				
			),
			array(
				'name' => __('Read more button','yeahthemes'),
				'desc' => __('Toggle to show/hide readmore button in blog page ','yeahthemes'),
				'id' => 'blog_readmore_button',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,

				'customize' => 1,
			),
			array(
				'name' => __('Post format icon','yeahthemes'),
				'desc' => __('The icon before Post meta info','yeahthemes'),
				'id' => 'blog_post_format_icon',
				'std' => 'show',
				'type' => 'toggles',
				'options' => array(
					'show' => __('Show', 'yeahthemes'), 
					'hide' => __('Hide', 'yeahthemes')
				),
				'customize' => 1,
			),
			array(
				'name' => __('Review info.','yeahthemes'),
				'desc' => __('Review info under the entries on main loops','yeahthemes'),
				'id' => 'blog_post_review_info',
				'std' => 'show',
				'type' => 'toggles',
				'options' => array(
					'show' => __('Show', 'yeahthemes'), 
					'hide' => __('Hide', 'yeahthemes')
				),
				'customize' => 1,
			),
			array( 
				'name' => __('Post Meta Info','yeahthemes'),
				'desc' => '',
				'id' => 'blog_post_meta_info_mode',
				'std' => 'small',
				'type' => 'select',
				'class' => 'yt-section-toggle-checkbox',
				'customize' => 1,
				'options' => array(
					'hide' => __('Hide', 'yeahthemes'),
					'small' => __('Style 1 (small Social button)', 'yeahthemes'),
					'large' => __('Style 2 (large Social buttons)', 'yeahthemes'),
				),
				'settings' => array(
					'folds' => '0',
					'label' => __('Toggle this to enable post meta info.','yeahthemes'),
				)
			),
			array(
				'name' => __('Hide Post meta info','yeahthemes'),
				'desc' => __('Uncheck to hide the meta info in blog page','yeahthemes'),
				'id' => 'blog_post_meta_info',
				'std' => array(
					'author',
					'category',
					'share_button',
					'date',
					'comments',
					'likes',
					'views',
					'sizer',
				),
				'type' => 'multicheck',
				'options' => array(
					'author' => __('Author of the Post','yeahthemes'),
					'category' => __('Post Category','yeahthemes'),
					'share_buttons' => __('Sharing buttons','yeahthemes'),
					'date' => __('Date of Post ','yeahthemes'),
					'comments' => __('Comments','yeahthemes'),
					'likes' => __('Likes','yeahthemes'),
					'views' => __('Post views','yeahthemes'),
					'sizer' => __('Font sizer','yeahthemes'),
				),
				'settings' => array(
					'fold' => 'blog_post_meta_info_mode',
					'fold_value' => 'small,large',
				)
				
			)
			
			
		) ) );
		
		/**
		 * Blog Settings - Single
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_blogsettings_single', array(
			array(
				'type' => 'subheading',
				'name' => __('Single post','yeahthemes'),
				'customize' => 1,
				'customize_name' => __('Blog Settings - Single post','yeahthemes'),
			),
			array(
				'name' => __('Featured image (Post thumnbnail)','yeahthemes'),
				'desc' => '',
				'id' => 'blog_single_post_featured_image',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,
				'customize' => 1,
			),
			array(
				'name' => __('Author Meta info.','yeahthemes'),
				'desc' => '',
				'id' => 'blog_single_post_author_meta',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,
				'customize' => 1,
			),
			array(
				'name' => __('Comment box','yeahthemes'),
				'desc' => '',
				'id' => 'blog_single_post_comment_template',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,
				'customize' => 1,
			),
			array(
				'name' => __('Related articles','yeahthemes'),
				'desc' => '',
				'id' => 'blog_single_post_related_articles',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,
				'customize' => 1,
			),array(
				'name' => __('You might also like section','yeahthemes'),
				'desc' => '',
				'id' => 'blog_single_post_youmightalsolike',
				'std' => 'show',
				'type' => 'toggles',
				'options' => $show_hide,
				'customize' => 1,
			)
		) ) );
			
		/**
		 * Typography
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_typography', array(
		
			array( 
				'name' => __('Typography','yeahthemes'),			
				'type' => 'heading',
				'settings' => array(
					'icon' => 'typography'
				)
			)
		) ) );
			
		/**
		 * Typography - Elements
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_typography_elements', array(
			
			array( 
				'name' => __('Elements','yeahthemes'),
				'type' => 'subheading',
				'desc' => __('Configure font parameters for element','yeahthemes'),
			),
			array(
				'name' => '',
				'type' => 'info',
				'std' => '<h3>Change your typography style in Content Area </h3><p>(From left to right:) Font Family, Font size, Font weight, Font style, Line height, Letter Spacing, Margin Bottom</p>'
			),
			array(
				'name' => __('H1 Headings','yeahthemes'),
				'desc' => __('default : Helvetica 30px normal normal 1.35 0px none 35px','yeahthemes'),
				'id' => 'typo_h1',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '30px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.35',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '35px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('H2 Headings','yeahthemes'),
				'desc' => __('default : 26px normal normal 1.35 0px none 30px','yeahthemes'),
				'id' => 'typo_h2',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '26px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.35',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '30px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('H3 Headings','yeahthemes'),
				'desc' => __('default : 22px normal normal 1.75 0px none 20px','yeahthemes'),
				'id' => 'typo_h3',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '22px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '20px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('H4 Headings','yeahthemes'),
				'desc' => __('default : 20px normal normal 1.75 0px none 20px','yeahthemes'),
				'id' => 'typo_h4',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '20px',
					'weight' 			=> 'normal',
					'style'				=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '20px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('H5 Headings','yeahthemes'),
				'desc' => __('default : 16px normal normal 1.75 0px none 15px','yeahthemes'),
				'id' => 'typo_h5',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '16px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '15px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('H6 Headings','yeahthemes'),
				'desc' => __('default : 13px normal normal 1.75 0px none 10px','yeahthemes'),
				'id' => 'typo_h6',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '13px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '10px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('Bold tag inside Headings','yeahthemes'),
				'desc' => __('The <strong>strong</strong> and <strong>b</strong> tag inside of Heading tags','yeahthemes'),
				'id' => 'typo_bold_heading',
				'std' => array(
					'face' 		=> '',
					'weight' 	=> 'bold',
					'style' 	=> 'normal',
				),
				'type' => 'typography'
			),
			array(
				'name' => __('Body Font','yeahthemes'),
				'desc' => __('Specify the body font properties Default: 13px normal normal 1.75 0px none','yeahthemes'),
				'id' => 'typo_body_font',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '13px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					//'color' 			=> ''
				),
				'type' => 'typography'
			)
		) ) );
		/**
		 * Typography - Elements - Header
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_typography_elements_header', array(
			array(
				'type' => 'separator',
				'name' => __('Header','yeahthemes'),
			),
			array(
				'name' => __('Main Menu','yeahthemes'),
				'desc' => __('default : 14px normal normal','yeahthemes'),
				'id' => 'typo_top_menu',
				'std' => array(
					'face' 			=> '',
					'size' 			=> '14px',
					'weight' 		=> 'normal',
					'style' 		=> 'normal',
					'transform' 	=> 'none',
					'letterspacing' 	=> '0px'
				),
				'type' => 'typography'
			),
			array(
				'name' => __('Main Menu Child Level','yeahthemes'),
				'desc' => __('default : 12px normal normal','yeahthemes'),
				'id' => 'typo_top_menu_child',
				'std' => array(
					'face' 			=> '',
					'size' 			=> '12px',
					'weight' 		=> 'normal',
					'style' 		=> 'normal',
					'transform' 	=> 'none',
					'letterspacing' 	=> '0px'
				),
				'type' => 'typography'
			),
		) ) );
		
		/**
		 * Typography - Elements - Content
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_typography_elements_content', array(
			array(
				'type' => 'separator',
				'name' => __('Content','yeahthemes'),
			),
			array(
				'name' => __('Home Brick Entry title','yeahthemes'),
				'desc' => __('default : 40px normal normal 50px 0px none 0px','yeahthemes'),
				'id' => 'typo_home_brick_entry_title',
				'std' => array(
					'face' 				=> '',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.25',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('Entry title','yeahthemes'),
				'desc' => __('default : 36px normal normal 1.35 0px none','yeahthemes'),
				'id' => 'typo_entry_title',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '36px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.35',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					//'marginbottom' 	=> '0px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('Single Page/Post title','yeahthemes'),
				'desc' => __('default : 40px normal normal 1.35 0px none','yeahthemes'),
				'id' => 'typo_page_title',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '40px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.35',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					//'marginbottom' 	=> '30px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('Sidebar widget\'s Headings','yeahthemes'),
				'desc' => __('default : 18px normal normal 1.75 0px none','yeahthemes'),
				'id' => 'typo_sidebar_widget_headings',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '18px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '15px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
		) ) );
		/**
		 * Typography - Elements - Footer
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_typography_elements_footer', array(
			array(
				'type' => 'separator',
				'name' =>  __('Footer','yeahthemes'),
			),
			array(
				'name' => __('Footer Headings','yeahthemes'),
				'desc' => __('default : 18px normal normal 1.75 0px none','yeahthemes'),
				'id' => 'typo_footer_headings',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '18px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					'marginbottom' 	=> '15px',
					//'color' 			=> ''
				),
				'type' => 'typography'
			),
			array(
				'name' => __('Footer Elements','yeahthemes'),
				'desc' => __('Specify the footer element font properties Default: 13px normal normal 1.75 0px none','yeahthemes'),
				'id' => 'typo_footer_element',
				'std' => array(
					'face' 				=> '',
					'size' 				=> '13px',
					'weight' 			=> 'normal',
					'style' 			=> 'normal',
					'height' 			=> '1.75',
					'letterspacing' 	=> '0px',
					'transform' 		=> 'none',
					//'color' 			=> ''
				),
				'type' => 'typography'
			)
		) ) );
		/**
		 * Typography - Google Font
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_typography_googlefont', array(
		
			array( 
				'name' => __('Google Font','yeahthemes'),
				'type' => 'subheading',
				'desc' => __('Add, Remove font from <a href="http://www.google.com/webfonts/" target="_blank">Google Web Fonts</a> Library','yeahthemes'),
			),
			array( 
				'name' => '',
				'desc' => '',
				'std' => __('<p>Checkout <a href="http://www.google.com/webfonts/" target="_blank">Google Web Fonts</a> Library. for a complete list of available font.</p>','yeahthemes'),
				'type' => 'info'
			),
			array( 
				'name' => __('Enable Google font','yeahthemes'),
				'desc' => __('Click <strong>Enable</strong> to use Google webfont from <strong>Font Family</strong> select box','yeahthemes'),
				'id' => 'googlefont_mode',
				'std' => 'disable',
				'type' => 'toggles',
				'options' => $enable_disable
			),
			array( 
				'name' => __('Character sets','yeahthemes'),
				'desc' => __('If you choose only the languages that you need, you\'ll help prevent slowness on your webpage.<br><br>Notice: The theme will load font subsets if available!','yeahthemes'),
				'id' => 'googlefont_subsets',
				'type' => 'multicheck',
				'std' => array(),
				'options' => array(
					'latin' => __('Latin','yeahthemes'),
					'latin-ext' => __('Latin Extended','yeahthemes'),
					'cyrillic' => __('Cyrillic','yeahthemes'),
					'cyrillic-ext' => __('Cyrillic Extended','yeahthemes'),
					'greek' => __('Greek','yeahthemes'),
					'greek-ext' => __('Greek Extended','yeahthemes'),
					'khmer' => __('Khmer','yeahthemes'),
					'vietnamese' => __('Vietnamese','yeahthemes'),
				)
				
			)
		) ) );
		/**
		 * Typography - Custom Font
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_typography_customfont', array(
				
			array( 
				'name' => __('Custom Font','yeahthemes'),
				'type' => 'subheading',
				'desc' => __('Upload Custom font from your Computer','yeahthemes')
			),
			array( 
				'name' => '',
				'desc' => '',
				'std' => '<h3>Upload your custom font</h3><p>Remember to Refesh this page after hitting Save Changes so the Font family list will update the new fonts</p>',
				'type' => 'info'
			),
			array( 
				'name' => __('Enable Custom font','yeahthemes'),
				'desc' => __('Click <strong>Enable</strong> to use Google webfont from <strong>Font Family</strong> select box','yeahthemes'),
				'id' => 'customfont_mode',
				'std' => 'disable',
				'type' => 'toggles',
				'options' => $enable_disable
			),
			array( 
				'name' => __('Upload Custom Fonts.','yeahthemes'),
				'desc' => __('Add your custom font for your site.<br>If you don\'t know how to create a fontface for web, you can generate at: <a href="http://www.fontsquirrel.com/fontface/generator">here</a><br><br>Font You have added:<br>','yeahthemes'),
				'id' => 'custom_fontface',
				'std' => '',
				'type' => 'repeatable_field',
				'options' => array(
					array(
						'name' => __('Font name','yeahthemes'),
						'desc' => '',
						'id' => 'font_name',
						'std' => '',
						'type' => 'text'
					),
					array(
						'name' => __('Font weight','yeahthemes'),
						'desc' => '',
						'id' => 'font_weight',
						'std' => '400',
						'type' => 'select',
						'options' => array(
							'100'=>'100 (Lighter)',
							'200'=>'200',
							'300'=>'300',
							'400'=>__('400 (Normal)','yeahthemes'),
							'500'=>'500',
							'600'=>'600',
							'700'=>__('700 (Bold)','yeahthemes'),
							'800'=>'800',
							'900'=>'900'
						)
					),
					array(
						'name' => __('Font style','yeahthemes'),
						'desc' => '',
						'id' => 'font_style',
						'std' => 'normal',
						'type' => 'select',
						'options' => array(
							'normal'=> __('Normal','yeahthemes'),
							'italic'=> __('Italic','yeahthemes')
						)
					),
					array(
						'name' => __('<b>.EOT</b> file','yeahthemes'),
						'desc' => '',
						'id' => 'font_eot',
						'std' => '',
						'type' => 'media',
						'settings' => array(
							'attr' => 'data-format="mixed"',
							'sanitize' => 'esc_url',
						)
					),
					array(
						'name' => __('<b>.WOFF</b> file','yeahthemes'),
						'desc' => '',
						'id' => 'font_woff',
						'std' => '',
						'type' => 'media',
						'settings' => array(
							'attr' => 'data-format="mixed"',
							'sanitize' => 'esc_url',
						)
					),
					array(
						'name' => __('<b>.TTF</b> file','yeahthemes'),
						'desc' => '',
						'id' => 'font_ttf',
						'std' => '',
						'type' => 'media',
						'settings' => array(
							'attr' => 'data-format="mixed"',
							'sanitize' => 'esc_url',
						)
					),
					array(
						'name' => __('<b>.SVG</b> file','yeahthemes'),
						'desc' => '',
						'id' => 'font_svg',
						'std' => '',
						'type' => 'media',
						'settings' => array(
							'attr' => 'data-format="mixed"',
							'sanitize' => 'esc_url',
						)
					),
				)
			
			),
			
		) ) );
		
		/**
		 * Styling Options
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_stylingoptions', array(	
			array( 
				'name' => __('Styling Options','yeahthemes'),
				'type' => 'heading',
				'customize' => 1,
				'settings' => array(
					'icon' => 'stylingoptions'
				)
			)
		) ) );
		/**
		 * Styling Options
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_stylingoptions_overall', array(	
			array( 
				'name' => __('Overall','yeahthemes'),
				'type' => 'subheading',
				'desc' => __('Configure Styling rule for overall elements','yeahthemes')
			),
			array(
				'name' => '',
				'type' => 'info',
				'std' => __('<h3>Choose the built-in skins!, if you dont like them, you can customize by colorpicking your favorite color schemes :)</h3>','yeahthemes')
			),
			array(
				'name' => __('Built-in Skins','yeahthemes'),
				'desc' => __('Select your themes alternative color scheme','yeahthemes'),
				'id' => 'builtin_skins',
				'std' => '',
				'type' => 'color_blocks',
				'settings' =>  array(
					'width' => '30px', 
					'height' => '30px'
				),
				'options' => yt_get_option_vars( 'skins' ),
				'customize' => 1
				
			),
			array(
				'name' => __('Enable Body background pattern','yeahthemes'),
				'desc' => __('if you are using  child theme, you can also add more background pattern by copying image to theme folderchild-theme-directory/images/bg/','yeahthemes'),
				'id' => 'body_bg_pattern_mode',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'settings' => array(
					'folds' => '0',
					'label' => __('Toggle this to enable background pattern','yeahthemes'),
				)
			),
			array(
				'name' => __('Body Background Pattern','yeahthemes'),
				'desc' => __('Select a background pattern. (The above uploaded image will be overwritten by this pattern)','yeahthemes'),
				'id' => 'body_bg_pattern',
				'type' => 'tiles',
				'options' => $bg_images,
				'settings' => array(
					'fold' => 'body_bg_pattern_mode',
				)
			),
			array(
				'name' => __('Body Background options','yeahthemes'),
				'desc' => __('default : no-repeat - center top - local - auto','yeahthemes'),
				'id' => 'body_bg_options',
				'std' => array(
					'repeat' => 'no-repeat',
					'position' => 'center top',
					'attachment' => 'local',
					'size' => 'auto',
					'color' => '',

					'image' => '',
				),
				'type' => 'background_options'
			),
			array(
				'type' => 'separator',
				'name' => __('Element colors','yeahthemes')
			),
			array(
				'name' => __('Primary color','yeahthemes'),
				'desc' => __('Pick a Primary color for your site.(this will overwrite built-in skins option)','yeahthemes'),
				'id' => 'primary_color',
				'std' => '',
				'type' => 'colorpicker',
				'customize' => 1
			),
			array( 
				'name' => __('Secondary color','yeahthemes'),
				'desc' => __('Pick a Secondary color for your site','yeahthemes'),
				'id' => 'secondary_color',
				'std' => '',
				'type' => 'colorpicker',
				'customize' => 1
			),
			array(
				'name' => __('Text color','yeahthemes'),
				'desc' => __('Pick a Text color for your site','yeahthemes'),
				'id' => 'text_color',
				'std' => '',
				'type' => 'colorpicker',
				'customize' => 1,
			),
			array( 
				'name' => __('Custom CSS','yeahthemes'),
				'desc' => __('Quickly add some CSS to your theme by adding it to this block.','yeahthemes'),
				'id' => 'custom_css',
				'std' => '/* Custom CSS*/',
				'type' => 'textarea',
				'class' => 'yt-widefat-section yt-tabifiable-textarea',
				'settings' => array(
					'rows' => '20',
					'sanitize' => false
				),
			)
		) ) );
		/**
		 * Styling Options - Header
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_stylingoptions_header', array(
			array( 
				'name' => __('Header','yeahthemes'),
				'type' => 'subheading',
				'desc' => __('Configure Styling rule for elements in site Header','yeahthemes'),
			),
			array(
				'name' => __('Header color style','yeahthemes'),
				'desc' => '',
				'id' => 'header_color_style',
				'std' => 'dark',
				'type' => 'select',
				'options' => array(
					'dark' => __( 'Dark (default)','yeahthemes'),
					'light' => __( 'Light','yeahthemes'),
					'color' => __( 'Primary color','yeahthemes'),
				),
				'customize' => 1
			),
			array(
				'name' => __('Background pattern','yeahthemes'),
				'desc' => __('if you are using  child theme, you can also add more background pattern by copying image to theme folderchild-theme-directory/images/bg/','yeahthemes'),
				'id' => 'header_bg_pattern_mode',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'settings' => array(
					'folds' => '0',
					'label' => __('Toggle this to enable background pattern','yeahthemes'),
				)
			),
			array(
				'name' => __('Background image options','yeahthemes'),
				'desc' => __('default : no-repeat - center top - local - auto','yeahthemes'),
				'id' => 'header_bg_options',
				'std' => array(
					'repeat' => 'no-repeat',
					'position' => 'center top',
					'attachment' => 'local',
					'size' => 'auto',
					'color' => '',
					'image' => '',
				),
				'type' => 'background_options',
			),
			array(
				'name' => __('Background Pattern','yeahthemes'),
				'desc' => __('Select a background pattern. (The above uploaded image will be overwritten by this pattern)','yeahthemes'),
				'id' => 'header_bg_pattern',
				'std' => $bg_images_url.'bg.png',
				'type' => 'tiles',
				'options' => $bg_images,
				'settings' => array(
					'fold' => 'header_bg_pattern_mode',
				)
			)
			
		
		) ) );
		/**
		 * Styling Options - Content
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_stylingoptions_content', array(	
			array( 
				'name' => __('Content','yeahthemes'),
				'type' => 'subheading',
				'desc' => __('Configure Styling rule for elements in site Content','yeahthemes'),
			),
			array(
				'type' => 'separator',
				'name' => __('Content Background Options','yeahthemes')
			),
			array(
				'name' => __('Background pattern','yeahthemes'),
				'desc' => __('if you are using  child theme, you can also add more background pattern by copying image to theme folderchild-theme-directory/images/bg/','yeahthemes'),
				'id' => 'content_bg_pattern_mode',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'settings' => array(
					'folds' => '0',
					'label' => __('Toggle this to enable background pattern','yeahthemes'),
				)
			),
			array(
				'name' => __('Background Options','yeahthemes'),
				'desc' => __('default : no-repeat - center top - local - auto','yeahthemes'),
				'id' => 'content_bg_options',
				'std' => array(
					'repeat' => 'no-repeat',
					'position' => 'center top',
					'attachment' => 'local',
					'size' => 'auto',
					'color' => '',

					'image' => '',
				),
				'type' => 'background_options'
			),
			array(
				'name' => __('Background Pattern','yeahthemes'),
				'desc' => __('Select a background pattern. (The above uploaded image will be overwritten by this pattern)','yeahthemes'),
				'id' => 'content_bg_pattern',
				'std' => $bg_images_url.'bg.png',
				'type' => 'tiles',
				'options' => $bg_images,
				'settings' => array(
					'fold' => 'content_bg_pattern_mode',
				)
				
			),
		) ) );
		/**
		 * Styling Options - Footer
		 */
		$yt_options = array_merge( $yt_options, apply_filters( 'yt_theme_options_stylingoptions_footer', array(	
			array( 
				'name' => __('Footer','yeahthemes'),
				'type' => 'subheading',
				'desc' => __('Configure Styling rule for elements in site Footer','yeahthemes'),
			),
			array(
				'name' => __('Footer Widgets Background Options','yeahthemes'),
				'desc' => __('default : no-repeat - center top - local - auto','yeahthemes'),
				'id' => 'footer_widgets_bg_options',
				'std' => array(
					'repeat' => 'no-repeat',
					'position' => 'center top',
					'attachment' => 'local',
					'size' => 'auto',
					'color' => '',
					
					'image' => '',
				),
				'type' => 'background_options',
			),	
			array(
				'name' => __('Background Pattern','yeahthemes'),
				'desc' => __('if you are using  child theme, you can also add more background pattern by copying image to theme folderchild-theme-directory/images/bg/','yeahthemes'),
				'id' => 'footer_widgets_bg_pattern_mode',
				'std' => 0,
				'type' => 'checkbox',
				'class' => 'yt-section-toggle-checkbox',
				'settings' => array(
					'folds' => '0',
					'label' => __('Toggle this to enable background pattern','yeahthemes'),
				)
			),
			array(
				'name' => __('Background Pattern','yeahthemes'),
				'desc' => __('Select a background pattern. (The above uploaded image will be overwritten by this pattern)','yeahthemes'),
				'id' => 'footer_widgets_bg_pattern',
				'std' => $bg_images_url.'bg.png',
				'type' => 'tiles',
				'options' => $bg_images,
				'settings' => array(
					'fold' => 'footer_widgets_bg_pattern_mode',
				)
			),	
			array(
				'name' =>  __('Footer Copyright info. Background Color','yeahthemes'),
				'desc' => __('Pick a background color for the footer copyright area .','yeahthemes'),
				'id' => 'footer_extra_bg_color',
				'std' => '',
				'type' => 'colorpicker',
				'customize' => 1,
			),
		) ) );
							
		return $yt_options;
		
	}
}