<?php
// This file is not called from WordPress. We don't like that.
! defined( 'ABSPATH' ) and exit;

/**
 **********************************************************************************************************
 * 												DO NOT EDIT THIS FILE
 **********************************************************************************************************
 * Theme Styling
 *
 * @author		Yeahthemes
 * @copyright	Copyright ( c ) Yeahthemes
 * @link		http://yeahthemes.com
 * @since		Version 1.0
 * @package 	Yeahthemes
 */
 /*
 * check if custom-styles.css is able to be written
 *
 * @since 1.0
 * @return string
 */

add_action( 'admin_init', 'yt_pre_check_custom_css_writable' );

function yt_pre_check_custom_css_writable() {


	//$access_type = get_filesystem_method();

	//echo $access_type;

	// custom css directory
	$the_dir = get_stylesheet_directory() . '/css';
	$external_dynamic_css = (bool) apply_filters( 'yt_site_dynamically_external_stylesheet', true );

	if( !file_exists( $the_dir) && $external_dynamic_css ){

		$msg = sprintf( '<div class="updated"><p>%s</p></div>', __( 'To use dynamically custom css from external file, make sure you have created "css" directory inside your child theme. ', 'yeahthemes') );
		add_action('admin_notices', create_function('', 'echo '. var_export( $msg, true ) . ';' ) );
	}
}
/*
 * Write to custom-styles.css
 *
 * @since 1.0
 * @return string
 */

if( !function_exists('yt_dynamic_options_css_writer')) {

	function yt_dynamic_options_css_writer( $new_data ) {

		
		/*Getting Credentials*/
		$url = wp_nonce_url('admin.php?page=yt-theme-options', 'yt-options-ajaxify-saving-data' );

		if (false === ($creds = request_filesystem_credentials($url, '', false, false, null) ) ) {
			return; // stop processing here
		}
		
		/*Initializing WP_Filesystem_Base*/
		if( ! WP_Filesystem( $creds ) ){
			
			request_filesystem_credentials($url, '', true, false, null);
			return true;
			
		}
	
		$uploads = wp_upload_dir();
		$css_dir = get_stylesheet_directory() . '/css/'; // Shorten code, save 1 call

		/* Save on different directory if on multisite */
		if( is_multisite() ) {
			$uploads_dir = trailingslashit( $uploads['basedir'] );
			
		} else {
			$uploads_dir = $css_dir;
		}
		
		$data = $new_data;
		$css = yt_site_get_dynamic_css( $data );
		
		/** Write to css file **/
		
		global $wp_filesystem;

		$lang = '';
		if( defined( 'ICL_LANGUAGE_CODE' ) && isset( $GLOBALS['sitepress'] ) && ICL_LANGUAGE_CODE !== $GLOBALS['sitepress']->get_default_language() ) {
	
			$lang = '_' . ICL_LANGUAGE_CODE;
			
		}

		$wrote = $wp_filesystem->put_contents( $uploads_dir . "custom-styles$lang.css", $css, FS_CHMOD_FILE );

		if( !$wrote ){
			//echo __('There\'s something wrong when writing css to file!, please make sure you have necessary permissions and css folder must be existed', 'yeahthemes');

			file_put_contents( $uploads_dir . "custom-styles$lang.css", $css );
			
			//Fallback to file_put_contents
			//file_put_contents( $uploads_dir . 'custom-styles.css', $css );
		} 
	}
}

/*
 * Init dynamic css based on selected type
 *
 * @since 1.0
 * @return string
 */
add_action( 'init', 'yt_site_custom_styles', 9 );

if( !function_exists( 'yt_site_custom_styles') ) {
	function yt_site_custom_styles(){

		$external_dynamic_css = (bool) apply_filters( 'yt_site_dynamically_external_stylesheet', true );

		// if use external file, enqueue it.
		if( $external_dynamic_css ){

			if( yt_get_options( '_init_options_time' ) ){
		
				add_action( 'ytto_after_option_data_saved','yt_dynamic_options_css_writer', 10);
			}

			add_action( 'yt_theme_scripts_after_enqueue_styles', create_function( '', 'wp_enqueue_style( \'custom-styles\' );') );
		}
		// Print css
		else{
			add_action( 'wp_head', create_function( '', 'echo \'<!--CUSTOM STYLE--><style type="text/css">\' . yt_site_get_dynamic_css() . \'</style><!--/CUSTOM STYLE-->\';'), 15);
		}
	}
}
/*
 * Dynamically genetate css using less css with pre-defined styles + theme options data
 *
 * @since 1.0
 * @return string
 */
if( !function_exists( 'yt_site_get_dynamic_css') ) {

	function yt_site_get_dynamic_css( $data = array() ){
		$lang = '';
		
		if( defined( 'ICL_LANGUAGE_CODE' ) && isset( $GLOBALS['sitepress'] ) && ICL_LANGUAGE_CODE !== $GLOBALS['sitepress']->get_default_language() ) {
	
			$lang = '_' . ICL_LANGUAGE_CODE;
			
		}
		$transient_name = 'yt_custom_styles' . $lang;
		$yt_data = empty( $data ) ? yt_get_options() : $data;

		$dir_uri = get_template_directory_uri();

		if( empty( $yt_data ) )
			return;

		// Primary color
		$primary_color = $yt_data['primary_color'] ? $yt_data['primary_color'] : ( $yt_data['builtin_skins'] ? $yt_data['builtin_skins'] : '#2cae8c');
		$primary_color = apply_filters( 'yt_site_styling_primary_color', $primary_color );

		$secondary_color = $yt_data['secondary_color'] ? $yt_data['secondary_color'] : '#363b3f';
		$text_color = $yt_data['text_color'] ? $yt_data['text_color'] : '#777777';

		$custom_css = '';

		/*Fontface*/
		/*Custom Css*/
		$custom_css .= !empty( $yt_data['custom_css'] ) ? $yt_data['custom_css'] : '';
		$custom_css .=  "\n" . yt_get_theme_customfonts();
		$custom_css .= 'h1{'. yt_output_option( 'typography', $yt_data['typo_h1'] ) . '}' . "\n";
		$custom_css .= 'h2{' . yt_output_option( 'typography', $yt_data['typo_h2'] ) . '}' . "\n";
		$custom_css .= 'h3, .widget-title{' . yt_output_option( 'typography', $yt_data['typo_h3'] ) . '}' . "\n";
		$custom_css .= 'h4{' . yt_output_option( 'typography', $yt_data['typo_h4'] ) . '}' . "\n";
		$custom_css .= 'h5{' . yt_output_option( 'typography', $yt_data['typo_h5'] ) . '}' . "\n";
		$custom_css .= 'h6{' . yt_output_option( 'typography', $yt_data['typo_h6'] ) . '}' . "\n";
		$custom_css .= 'h1 strong, h2 strong, h3 strong, h4 strong, h5 strong, h6 strong{' . yt_output_option( 'typography', $yt_data['typo_bold_heading'] ) . '}' . "\n";
		// Body
		$custom_css .= 'body{';
			$custom_css .= "color:$text_color;";
			$custom_css .= yt_output_option( 'typography', $yt_data['typo_body_font'] );			
			if($yt_data['body_bg_pattern_mode'] && $yt_data['body_bg_pattern'] )
				$yt_data['body_bg_options']['image'] = $yt_data['body_bg_pattern'];
			$custom_css .= yt_output_option( 'background_options', $yt_data['body_bg_options'] )  . "\n" ;
		$custom_css .= '}' . "\n";

		// #page
		$custom_css .= '.inner-wrapper{';
			if($yt_data['content_bg_pattern_mode'] && $yt_data['content_bg_pattern'] )
				$yt_data['content_bg_options']['image'] = $yt_data['content_bg_pattern'];
			$custom_css .= yt_output_option( 'background_options', $yt_data['content_bg_options'] )  . "\n" ;
		$custom_css .= '}' . "\n";

		$custom_css .= '.site-header .site-banner{';
			if($yt_data['header_bg_pattern_mode'] && $yt_data['header_bg_pattern'] )
				$yt_data['header_bg_options']['image'] = $yt_data['header_bg_pattern'];
			$custom_css .= yt_output_option( 'background_options', $yt_data['header_bg_options'] )  . "\n" ;
		$custom_css .= '}' . "\n";
		$custom_css .= '.site-header .main-navigation ul.menu > li > a, .site-mobile-navigation ul.menu > li {' . yt_output_option( 'typography', $yt_data['typo_top_menu'] ) . '}' . "\n";
		$custom_css .= '.site-header ul ul.sub-menu > li, .site-mobile-navigation ul ul.sub-menu > li{' . yt_output_option( 'typography', $yt_data['typo_top_menu_child'] ) . '}' . "\n";
		
		
		$custom_css .= '.site-content article .entry-title{' . yt_output_option( 'typography', $yt_data['typo_entry_title'] ) . '}' . "\n";
		$custom_css .= 'h1.page-title, h1.entry-title, .site-content article h1.entry-title{' . yt_output_option( 'typography', $yt_data['typo_page_title'] ) . '}' . "\n";
		$custom_css .= '.widget-title{' . yt_output_option( 'typography', $yt_data['typo_sidebar_widget_headings'] ) . '}' . "\n";
		$custom_css .= sprintf( 
			'#site-hero h2.entry-title{%s%s}' . "\n",
			yt_output_option( 'typography', $yt_data['typo_home_brick_entry_title'] ),
			sprintf(  "\t" . 'max-height:%sem;' . "\n", $yt_data['typo_home_brick_entry_title']['height']*2 )
		);
		
		/*Background style*/
		//site-footer
		$custom_css .= '.footer-widgets{' . "\n";
			if($yt_data['footer_widgets_bg_pattern_mode'] && $yt_data['footer_widgets_bg_pattern'] )
				$yt_data['footer_widgets_bg_options']['image'] = $yt_data['footer_widgets_bg_pattern'];
			$custom_css .= yt_output_option( 'background_options', $yt_data['footer_widgets_bg_options'] )  . "\n" ;
			$custom_css .= yt_output_option( 'typography', $yt_data['typo_footer_element'] ). "\n";
		$custom_css .= '}' . "\n";

		$custom_css .= '.footer-widgets h1, 
		.footer-widgets h2, 
		.footer-widgets h3, 
		.footer-widgets h4, 
		.footer-widgets h5, 
		.footer-widgets h6{' . yt_output_option( 'typography', $yt_data['typo_footer_headings'] ) . '}' . "\n";

		$custom_css .= $yt_data['footer_extra_bg_color'] ? '.site-footer .footer-info{ background-color:' . $yt_data['footer_extra_bg_color'] . ';}' : '';

		
		if( 'color' == $yt_data['header_color_style'] )
			$header_color_style = '@primaryColor';
		elseif( 'dark' == $yt_data['header_color_style'] )
			$header_color_style = '@secondaryColor';
		else
			$header_color_style = '@whiteColor';
		

		//Allow modifying via filter
		$less_css_vars = apply_filters('yt_site_less_css_variables', array(

			'@textColor' 					=> '#777777',
			'@boldColor' 					=> '#333333',
			'@grayColor' 					=> '#aaaaaa',
			'@grayBgColor'					=> '#fafafa',
			'@whiteColor'					=> '#ffffff',
			'@blackColor'					=> '#000000',
			'@borderOpacity' 				=> '0.08',
			'@borderRadius' 				=> '2px',
			'@baseFontSize'					=> !empty( $yt_data['typo_body_font']['size'] ) ? $yt_data['typo_body_font']['size'] : '14px',
			'@iconFonts'					=> '"FontAwesome"',
			'@imageURI'						=> '"' .$dir_uri .'"',

			// =Colors
			'@defaultColor'					=> '#fafafa',
			'@primaryColor' 				=> $primary_color,
			'@secondaryColor' 				=> $secondary_color,
			'@successColor'        			=> '#5cb85c',
			'@infoColor'            		=> '#5bc0de',
			'@warningColor'         		=> '#f0ad4e',
			'@dangerColor'          		=> '#d9534f',

			// =Body
			'@bodyTextColor' 				=> '@textColor',
			'@linkColor' 					=> '@primaryColor',
			'@linkHoverColor' 				=> '@secondaryColor',
			'@boldTextColor' 				=> '@secondaryColor',
			'@grayBorderColor' 				=> 'mix( @whiteColor, @secondaryColor, 92%)',
			'@grayBorderColorTransparent'	=> 'fade(@secondaryColor, 8%)',

			// =Header
			'@headerBgColor' 				=> !empty( $yt_data['header_bg_options']['color'] ) ? $yt_data['header_bg_options']['color'] : $header_color_style,

			'@headerTopMenuBgColor' 		=> 	'darken(@headerBgColor, 5%)',
			'@headerTopMenuLinkColor' 		=> 	'light' == $yt_data['header_color_style'] ? 'mix( @headerBgColor, @blackColor, 50%)'  : 'mix( @headerBgColor, @whiteColor, 50%)',
			'@headerTopMenuLinkHoverColor' => 	'light' == $yt_data['header_color_style'] ? '@primaryColor' : '@whiteColor',

			// =Mobile navigation
			'@mobileMenuBgColor' 			=> '@headerTopMenuBgColor',
			'@mobileMenuLinkColor' 			=> '@headerTopMenuLinkColor',
			'@mobileMenuLinkHoverColor' 	=> '@headerTopMenuLinkHoverColor',

			// Menu
			'@headerMenuLinkColor' 			=> 'light' == $yt_data['header_color_style'] ? 'mix( @headerBgColor, @blackColor, 50%)' : 'mix( @headerBgColor, @whiteColor, 20%)', 
			'@headerMenuLinkHoverColor' 	=> '@secondaryColor',
			'@headerMenuLinkActiveColor' 	=> '@primaryColor',
			'@headerMenuLinkActiveBgColor' 	=> 'light' == $yt_data['header_color_style'] ? 'darken(@headerBgColor, 5%)' : '@whiteColor',

			// Sub Menu
			'@headerSubMenuLinkColor' 	 	=> '@textColor',
			'@headerSubMenuLinkHoverColor' 	=> '@primaryColor',
			'@headerSubMenuLinkActiveColor' => '@primaryColor',

			// =Content
			'@contentLinkColor' 			=> '@primaryColor',
			'@contentLinkHoverColor'		=> '@secondaryColor',
			'@contentMenuLinkColor' 		=> '@secondaryColor',
			'@contentMenuLinkHoverColor'	=> '@primaryColor',
			'@contentMenuLinkActiveColor'	=> '@primaryColor',
			'@contentTextColor'				=> '@textColor',

			// =Sidebar
			'@sidebarTextColor' 			=> '@textColor',
			'@sidebarLinkColor' 			=> '@primaryColor',
			'@sidebarLinkHoverColor' 		=> '@secondaryColor',
			'@sidebarMenuLinkColor' 		=> '@secondaryColor',
			'@sidebarMenuLinkHoverColor' 	=> '@primaryColor',
			'@sidebarMenuLinkActiveColor' 	=> '@primaryColor',

			// =Footer
			// Footer widgets
			'@footerTextColor' 				=> '@textColor',
			'@footerLinkColor' 				=> '@primaryColor',
			'@footerLinkHoverColor' 		=> '@secondaryColor',
			'@footerMenuLinkColor' 			=> '@textColor',
			'@footerMenuLinkHoverColor' 	=> 'darken( @textColor, 30%)',
			'@footerMenuLinkActiveColor' 	=> '@primaryColor',
		) );

		//print_r( $less_css_vars );die();
		// Join the variable array
		$less_css_vars_string = '';
		foreach ($less_css_vars as $key => $value) {
			$less_css_vars_string .= "$key:$value;\n";
		}
		// 
		$less_css = '';
		$less_transient_name = 'yt_transient_theme_less_css';
		$compiled_css_transient_name = 'yt_transient_theme_compiled_less_css';

		$less_css = get_transient( $less_transient_name );
		$compiled_css = get_transient( $compiled_css_transient_name );

		if( empty( $transient_less_css ) ){


			$less_css .= @yt_file_get_contents( get_template_directory() . '/framework/css/mixins.less', true );
			$less_css .= @yt_file_get_contents( get_template_directory() . '/css/theme-mixins.less', true );
			$less_css .= @yt_file_get_contents( get_template_directory() . '/css/bootstrap-theme.less', true );
			$less_css .= @yt_file_get_contents( get_template_directory() . '/css/custom-styles.less', true );

			// // Retrieve mixins		
			// $mixins = wp_remote_get( $dir_uri . '/framework/css/mixins.less', array( 'sslverify'   => false) );
			// $less_css .= !is_wp_error( $mixins ) ? wp_remote_retrieve_body( $mixins ) : '';

			// // Theme mixins
			// $theme_mixins = wp_remote_get( $dir_uri . '/css/theme-mixins.less', array( 'sslverify'   => false) );
			// $less_css .= !is_wp_error( $theme_mixins ) ? wp_remote_retrieve_body( $theme_mixins ) : '';
			
			// // Bootstrap theme
			// $bootstrap_theme = wp_remote_get( yt_get_overwritable_directory_uri( '/css/bootstrap-theme.less' ), array( 'sslverify'   => false) );
			// $less_css .= !is_wp_error( $bootstrap_theme ) ? wp_remote_retrieve_body( $bootstrap_theme ) : '';

			// // Theme style
			// $theme_style = wp_remote_get( yt_get_overwritable_directory_uri( '/css/custom-styles.less' ), array( 'sslverify'   => false) );
			// $less_css .= !is_wp_error( $theme_style ) ? wp_remote_retrieve_body( $theme_style ) : '';
			

			/**
			 * Category color
			 */
			$post_categories = get_categories();



			/**
			 * Init Category custom fields
			 */
			if( !class_exists( 'YT_Category_Custom_Fields' ) )
				require_once( YEAHTHEMES_FRAMEWORK_DIR . 'classes/class.category-custom-fields.php' );

			global $yt_category_fields;

			$yt_category_fields  = new YT_Category_Custom_Fields();

			if( is_a( $yt_category_fields, 'YT_Category_Custom_Fields' )){
			
				if( !empty( $post_categories ) ){
					foreach ($post_categories as $cat) {
						$cat_color = '';
						$cat_color = $yt_category_fields->get_category_meta($cat->cat_ID, 'color');
						$less_css .= $cat_color ? "\t.cat-tag.{$cat->slug}{ background-color:{$cat_color};}\n" : "";
						$less_css .= $cat_color ? "\t.site-hero.style-color-gradient article.category-{$cat->slug} .entry-thumbnail:before{
							#gradient > .diagonal(@start-color: rgba( red({$cat_color}), green({$cat_color}), blue({$cat_color}),1); @end-color: rgba( red({$cat_color}), green({$cat_color}), blue({$cat_color}),0); @start-percent: 0%; @end-percent: 100%; @deg: 45deg);
						}\n" : "";
					}
					
				}
			}

			$less_css .= 'html #page .review-total-only>*{color:@whiteColor;}';

			/**
			 * Wide layout for large display
			 */
			if( $yt_data['site_width_large_mode'] ){
				$less_css .= "\n\n@media (min-width: 1400px){
					.boxed-layout{
						&.large-display-layout{
							#page, .site-banner{
								width: 1400px;
							}
						}
					}
					.container {
						width: 1370px;
					}
					.site-hero{
						.hero-brick{
							.entry-header{
								h2{
									font-size: 24px;
								}
							}
							&.hero-brick-large{
								.entry-header{
									h2{
										font-size: 48px;
										line-height: 1.25;
									}
								}
							}
							
							.posted-on,.entry-category{
								display:block;
							}
						}
					}
				}";
			} 

			set_transient( $less_transient_name, $less_css );

		}

		//yt_pretty_print( $less_css_vars_string);

		// Prepend dynamic var
		$less_css = $less_css_vars_string . $less_css;

		// $less_css = '@lessColor: #333333;

		// .yeahthemes{color:@lessColor;}';

		if( empty( $compiled_css ) ){

			$remote_parser = apply_filters( 'yt_site_dynamic_css_remote_parser_mode', false ) ;

			if( !$remote_parser ){

				if( !class_exists( 'Less_Parser' ) )
					require_once( YEAHTHEMES_FRAMEWORK_DIR . 'extended/less-parser/Less.php' );
				
				try{
					$parser = new Less_Parser();

					$parser->parse( $less_css );

					$compiled_css = $parser->getCss();
				}catch(Exception $e){
					$error_message = $e->getMessage();
				}
			}

			$compiled_css = apply_filters( 'yt_site_dynamic_css_before_set_transient', $compiled_css, $less_css );
			
			set_transient( $compiled_css_transient_name, $compiled_css );
		}

		// Compile less css
		

		// Append to custom css
		$custom_css = $compiled_css . $custom_css;

		// Inline css :P
		$custom_css = str_replace(array("\r", "\n", "\t"), "", $custom_css);

		// Allow filtering
		$custom_css = apply_filters( 'yt_site_dynamic_css', $custom_css );

		return $custom_css;

		// wp_add_inline_style( 'yt-custom-styles', $custom_css );

	}
}
/*
 * Remove transients after updating theme options
 *
 * @since 1.0
 * @return string
 */
add_filter( 'yt_refresh_transient_list_after_updating_theme_options', 'yt_site_flush_styling_transient' );

function yt_site_flush_styling_transient( $list ){

	$list[] = 'yt_transient_theme_less_css';
	$list[] = 'yt_transient_theme_compiled_less_css';
	return $list;
}