<?php
/**
 **********************************************************************************************************
 * 										WARNING: DO NOT EDIT THIS FILE
 **********************************************************************************************************
 *
 * Custom template tags for theme.
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * @package yeahthemes
 * @since 1.0
 * @framework 1.0
 */
/*
 * Post atts
 *
 * @since 1.0
 * @framework 1.0.3.2
 */
if( !function_exists( 'yt_post_atts' ) ){
	function yt_post_atts(){
		
		$atts = apply_filters( 'yt_post_atts', array() );

		if( !empty( $atts) ){
			$count = 0;
			foreach ( (array) $atts as $key => $value) {
				$count++;


				echo sprintf( ( 1== $count ? '%s="%s"' : ' %s="%s"' ), $key, $value );
			}
		}
	}
}

/*
 * Font size changer
 *
 * @since 1.0
 * @framework 1.0
 */
if( !function_exists( 'yt_theme_font_size_changer') ) {
	function yt_theme_font_size_changer( $extra_class = ''){
		
		$extra_class = $extra_class ? ' ' . $extra_class : '';
		?>
		<div class="yt-font-size-changer<?php echo esc_attr( $extra_class );?>">
			<span class="font-size-minus">A-</span>
			<span class="font-size-default">A</span>
			<span class="font-size-plus">A+</span>
		</div>
		<?php
		
	}
}

/*
 * Footer Sidebar
 *
 * @since 1.0
 * @framework 1.0
 */
if( !function_exists('yt_theme_footer_sidebars')) {
	
	function yt_theme_footer_sidebars( $columns = '', $name = '', $wrapper = 'div'){
		
		$footer_columns = empty( $columns ) ? yt_get_options( 'footer_columns' ) : $columns;
		//retrieve number of columns from theme option
		$fw_name = $name ? $name : 'footer-widget-';

		if( $footer_columns ) {
			
			$footer_col_array = explode('_', $footer_columns );

			$i = 0;
			$count = 0;

			//print_r( $footer_col_array ); die();
			foreach ( $footer_col_array as $col ) {
				# code...
				//echo $col.'<br>';
				$count++;
				if( in_array( $col, array( 'clear', 'clearfix', 'hr' ) ) ){

					
					echo '<' . esc_attr( $wrapper ) . ' class="clear col-sm-12">';
						if( 'hr' == $col )
							echo '<hr/>';
					echo '</' . esc_attr( $wrapper ) . '>';	
					
				}else{
					$i++;
					$extra_class = $count % 2 == 0 ? " even" : " odd";
					$extra_class .= " footer-col-$count";
					if( !empty( $col ) ){
						echo '<' . esc_attr( $wrapper ) . ' class="' . esc_attr( $col . $extra_class ) .'">';
							dynamic_sidebar( $fw_name . ( $i ) );
						echo '</' . esc_attr( $wrapper ) . '>';	
					}
				}
			}
			/*
			for( $i = 0; $i < count( $footer_col_array ); $i++){
				if( !empty( $footer_col_array[$i] ) ){
					echo '<' . esc_attr( $wrapper ) . ' class="' . esc_attr( $footer_col_array[$i] ) .'">';
						dynamic_sidebar( $fw_name . ( $i + 1 ) );
					echo '</' . esc_attr( $wrapper ) . '>';	
				}
					
			}*/
			
		}
	}
}
/**
 * Display navigation to next/previous pages when applicable
 *
 * @since 1.0
 * @framework 1.0
 */
if ( ! function_exists( 'yt_direction_nav' ) ) {
	
	function yt_direction_nav( $nav_id = '', $extra_class = 'gray-2-primary' ) {


		do_action('yt_direction_nav');
		
		if( has_action( 'yt_direction_nav' ))
			return;
		
		global $wp_query, $post;
	
		// Don't print empty markup on single pages if there's nowhere to navigate.
		if ( is_single() ) {
			$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
			$next = get_adjacent_post( false, '', false );
	
			if ( ! $next && ! $previous )
				return;
		}
	
		// Don't print empty markup in archives if there's only one page.
		if ( $wp_query->max_num_pages < 2 && ( is_home() || is_archive() || is_search() ) )
			return;
	
		$nav_class = 'post-page-navigation';
		$icon_prev = apply_filters('yt_icon_prev_post', '');
		$icon_next = apply_filters('yt_icon_next_post', '');
		$title_prev = is_single() ? __('Older Entry', 'yeahthemes') : __('Older Entries', 'yeahthemes');
		$title_next = is_single() ? __('Newer Entry', 'yeahthemes') : __('Newer Entries', 'yeahthemes');
	
		?>
		<nav role="navigation" id="<?php echo esc_attr( $nav_id ); ?>" class="<?php echo esc_attr( $nav_class ); ?> direction-nav hidden-print<?php echo esc_attr( $extra_class ? " $extra_class" : '' );?>">
			<h4 class="screen-reader-text hidden"><?php _e( 'Post navigation', 'yeahthemes' ); ?></h4>
	
		<?php if ( is_single() ) : // navigation links for single posts ?>
	
			<?php previous_post_link( '<div class="nav-previous" data-heading="' . esc_attr( $title_prev ) . '">%link</div>', $icon_prev . '<span class="pager-title">%title</span>' ); ?>
			<?php next_post_link( '<div class="nav-next" data-heading="' . esc_attr( $title_next ) . '">%link</div>', $icon_next . '<span class="pager-title">%title</span>' ); ?>
	
		<?php elseif ( $wp_query->max_num_pages > 1 && ( is_home() || is_archive() || is_search() ) ) : // navigation links for home, archive, and search pages ?>
	
			<?php if ( get_next_posts_link() ) : ?>
			<div class="nav-previous" data-heading="<?php esc_attr_e( $title_prev );?>"><?php next_posts_link( $icon_prev . '<span class="pager-title">' . $title_prev . '</span>'); ?></div>
			<?php endif; ?>
			<?php if ( get_previous_posts_link() ) : ?>
			<div class="nav-next" data-heading="<?php esc_attr_e( $title_next );?>"><?php previous_posts_link( $icon_next . '<span class="pager-title">' . $title_next . '</span>' ); ?></div>
			<?php endif; ?>
	
		<?php endif; ?>
	
		</nav><!-- #<?php echo esc_html( $nav_id ); ?> -->
		<?php
	}

}// yt_direction_nav


/**
 * Display Paginated navigation
 *
 * @since 1.0
 * @framework 1.0
 */
if ( ! function_exists( 'yt_pagination_nav' ) ) {
	function yt_pagination_nav( $class = "gray-2-primary" ) {

		do_action('yt_pagination_nav');
		
		if( has_action( 'yt_pagination_nav' ))
			return;
	?>
	<nav role="navigation" class="<?php esc_attr_e( $class );?> pagination-nav hidden-print clearfix">
		<h4 class="screen-reader-text hidden"><?php _e( 'Post navigation', 'yeahthemes' ); ?></h4>
		<div class="pull-left">
			<?php
				global $wp_query;
				
				$big = 999999999; 
				
				echo paginate_links( apply_filters( 'yt_pagination_nav_paginate_links_args', array(
					'base' 		=> str_replace( $big, '%#%', get_pagenum_link( $big ) ),
					'format' 	=> '?paged=%#%',
					'current' 	=> max( 1, get_query_var('paged') ),
					'total' 	=> $wp_query->max_num_pages,
					'next_text'	=> __('Next &rarr;','yeahthemes'),
					'prev_text'	=> __('&larr; Prev','yeahthemes'),
				) ) );
			?>
		</div>
		
		<div class="pull-right hidden-xs">
			<span class="pagination-meta">
			<?php
				//display Page x of y pages
				$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				
				echo sprintf( __( 'Page %d of %d','yeahthemes' ), esc_html( $paged ), esc_html( $wp_query->max_num_pages ) );
			
			?>
			</span>
		</div>
	
	</nav>
	<?php
    
	}
}

/**
 * Template for comments and pingbacks.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since 1.0
 * @framework 1.0
 */
if ( ! function_exists( 'yt_comment' ) ) {
	
	function yt_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		
		//print_r($comment);
	
		if ( 'pingback' == $comment->comment_type || 'trackback' == $comment->comment_type ) : ?>
	
		<li id="comment-<?php echo esc_attr( get_comment_ID()); ?>" <?php comment_class(); ?>>
			<div class="comment-body">
				<?php _e( 'Pingback:', 'yeahthemes' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( 'Edit', 'yeahthemes' ), '<span class="edit-link">', '</span>' ); ?>
			</div>
	
		<?php else : ?>
	
		<li id="comment-<?php echo esc_attr( get_comment_ID()); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?>>
			<?php echo (isset($comment->comment_number) ? '<span class="comment-number">' . esc_html( $comment->comment_number ) . '</span>' : ''); ?>
			
			<article id="div-comment-<?php echo esc_attr( get_comment_ID()); ?>" class="comment-body">
				<footer class="comment-meta">
					<div class="comment-author vcard">
						<?php if ( 0 != $args['avatar_size'] ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
						<?php printf( '<cite class="fn">%s</cite>', get_comment_author_link() ); ?>
					</div><!-- .comment-author -->
	
					<div class="comment-metadata">
						<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
							<time datetime="<?php comment_time( 'c' ); ?>">
								<?php printf( _x( '%1$s at %2$s', '1: date, 2: time', 'yeahthemes' ), get_comment_date( 'M j, Y' ), get_comment_time() ); ?>
							</time>
						</a>
						
					</div><!-- .comment-metadata -->
	
					<?php if ( '0' == $comment->comment_approved ) : ?>
					<p class="comment-awaiting-moderation clear"><em><?php esc_html_e( 'Your comment is awaiting moderation.', 'yeahthemes' ); ?></em></p>
					<?php endif; ?>
				</footer><!-- .comment-meta -->
				
				<?php do_action('yt_after_comment_meta', $comment);?>
	
				<div class="comment-content">
					<?php comment_text(); ?>
				</div><!-- .comment-content -->
	
				<div class="comment-reply-edit">
					<?php 
					
						do_action('yt_comment_reply_edit_start', $comment);
						
						comment_reply_link( array_merge( $args, array( 'reply_text' => apply_filters('yt_icon_reply_comment', '<i class="fa fa-reply"></i>') . ' ' . __('Reply', 'yeahthemes'), 'add_below' => 'div-comment', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) );
						
						edit_comment_link(  __( 'Edit', 'yeahthemes' ) );
						
						do_action('yt_comment_reply_edit_end', $comment);
					
					?>
				</div><!-- .reply -->
				
				
			</article><!-- .comment-body -->
	
		<?php
		endif;
	}
} // ends check for yt_comment()

/**
 * Prints the attached image with a link to the next attached image.
 *
 * @since 1.0
 * @framework 1.0
 */
if ( ! function_exists( 'yt_the_attached_image' ) ) {

	function yt_the_attached_image() {
		$post                = get_post();
		$attachment_size     = apply_filters( 'yt_attachment_size', array( 1200, 1200 ) );
		$next_attachment_url = wp_get_attachment_url();
	
		/**
		 * Grab the IDs of all the image attachments in a gallery so we can get the
		 * URL of the next adjacent image in a gallery, or the first image (if
		 * we're looking at the last image in a gallery), or, in a gallery of one,
		 * just the link to that image file.
		 */
		$attachment_ids = get_posts( array(
			'post_parent'    => $post->post_parent,
			'fields'         => 'ids',
			'numberposts'    => -1,
			'post_status'    => 'inherit',
			'post_type'      => 'attachment',
			'post_mime_type' => 'image',
			'order'          => 'ASC',
			'orderby'        => 'menu_order ID'
		) );
	
		// If there is more than 1 attachment in a gallery...
		if ( count( $attachment_ids ) > 1 ) {
			foreach ( $attachment_ids as $attachment_id ) {
				if ( $attachment_id == $post->ID ) {
					$next_id = current( $attachment_ids );
					break;
				}
			}
	
			// get the URL of the next image attachment...
			if ( $next_id )
				$next_attachment_url = get_attachment_link( $next_id );
	
			// or get the URL of the first image attachment.
			else
				$next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
		}
	
		printf( '<a href="%1$s" title="%2$s" rel="attachment">%3$s</a>',
			esc_url( $next_attachment_url ),
			the_title_attribute( array( 'echo' => false ) ),
			wp_get_attachment_image( $post->ID, $attachment_size )
		);
	}
}

/**
 * Prints HTML with meta information for the current post-date/time and author.
 *
 * @since 1.0
 * @framework 1.0
 */
 
if ( ! function_exists( 'yt_post_meta_description' ) ) {
	
	function yt_post_meta_description( $_item_wrapper = 'span' ) {

		$_item_wrapper = $_item_wrapper ? $_item_wrapper : 'span';
		
		do_action('yt_theme_before_post_meta_description');

		do_action('yt_theme_post_meta_description');
		
		if( !has_action( 'yt_theme_post_meta_description' )){
		
			/*$categories = get_the_category();
			$separator = ' ';
			$output = '';
			if($categories){
				foreach($categories as $category) {
					$output .= '<a class="'.$category->slug.'" href="'. get_category_link( $category->term_id ).'" title="' . esc_attr( sprintf( __( "View all posts in %s" ), $category->name ) ) . '">'.$category->cat_name.'</a>'.$separator;
				}
				echo trim($output, $separator);
			}*/
			$data = yt_get_options('blog_post_meta_info');
			if( in_array( 'date', $data) ){
				$time_string = '<time class="entry-date published%5$s" datetime="%1$s">%2$s</time>';
				if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
					$time_string .= '<time class="updated hidden" datetime="%3$s">%4$s</time>';
			
				$time_string = sprintf( $time_string,
					esc_attr( get_the_date( 'c' ) ),
					esc_html( get_the_date() ),
					esc_attr( get_the_modified_date( 'c' ) ),
					esc_html( get_the_modified_date() ),
					get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ? '' : ' updated'
				);
				
				printf( '<%2$s class="by-author">%1$s</%2$s>',
					sprintf( '<a href="%1$s" title="%2$s" rel="bookmark">%3$s</a>',
						esc_url( get_permalink() ),
						esc_attr( get_the_time() ),
						$time_string
					),
					esc_html( $_item_wrapper )	
				);
			}
			//Author
			if( in_array( 'author', $data) ){
				printf( '<%3$s class="by-author">%1$s%2$s</%3$s>',
					_x( 'by ', 'post meta info', 'yeahthemes' ), 
					sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
						esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
						esc_attr( sprintf( __( 'View all posts by %s', 'yeahthemes' ), get_the_author() ) ),
						esc_html( get_the_author() )
					),
					esc_html( $_item_wrapper )	
				);
			}
			//category
			if( in_array( 'category', $data) ){
				printf( '<%3$s class="in-cat">%1$s%2$s</%3$s>',
					_x( 'in ', 'post meta info', 'yeahthemes' ), 
					get_the_category_list( __( ', ', 'yeahthemes' ) ),
					esc_html( $_item_wrapper )	
				);
			}
			
			//comments
			if( in_array( 'comments', $data) ){
				echo sprintf( '<%s class="with-cmt">', esc_html( $_item_wrapper ) );
					comments_popup_link( __( '0 Comments', 'yeahthemes' ), __( '1 Comment', 'yeahthemes' ), __( '% Comments', 'yeahthemes' ));
				echo sprintf( '</%s>', $_item_wrapper );
			}
		}
		do_action('yt_theme_after_post_meta_description');
		
	}
}

/*
 * Theme get post formats - image
 *
 * @since 1.0
 * @framework 1.0
 */
if( !function_exists( 'yt_get_the_post_format_image') ) {
	function yt_get_the_post_format_image( $post_id = null, $size = 'full' ){
		
		if( empty( $post_id ) && isset( $GLOBALS['post'] ) ){
			$post = $GLOBALS['post'];
		}else{
			$post = get_post( $post_id );
		}
		
		if ( empty( $post ) )
			return '';
		
		$output = '';
		$formats_meta = yt_get_post_formats_meta( $post->ID );
		
		if( empty( $formats_meta['_format_image'] ) ){
			return '';
		}else{
			if( !empty( $formats_meta['_format_url'] ) )
				$output = '<a target="_blank" href="' . esc_url( $formats_meta['_format_url'] ) . '" title="' . esc_attr( $post->post_title ) . '"><img src="' . esc_url( $formats_meta['_format_image'] ) . '" class="" alt="' . esc_attr( $post->post_title ) . '"></a>';
			else
				$output = '<img src="' . esc_url( $formats_meta['_format_image'] ) . '" class="" alt="' . esc_attr( $post->post_title ) . '">';
				
		}
			
		
		return apply_filters( 'yt_the_post_format_image_content', $output, $post->ID );
	}
}
/*
 * Theme get post formats - Gallery
 *
 * @since 1.0
 * @framework 1.0
 */
if( !function_exists( 'yt_get_the_post_format_gallery') ) {
	function yt_get_the_post_format_gallery( $post_id = null, $size = 'large' ){

		
		if( empty( $post_id ) && isset( $GLOBALS['post'] ) ){
			$post = $GLOBALS['post'];
		}else{
			$post = get_post( $post_id );
		}
		if ( empty( $post ) )
			return '';
		

		$output = '';
		$formats_meta = yt_get_post_formats_meta( $post->ID );
		
		if( empty( $formats_meta['_format_gallery'] ) ){
			return '';
		}else{
			$ids = explode( ',', $formats_meta['_format_gallery'] );
			$ids = array_filter( $ids );

			$args = array(
			  'post_type' => 'attachment',
			  'post__in' => $ids,
			  'posts_per_page' => -1
			);
			
			$attachments = get_posts($args);
			
			$slider_settings = apply_filters( 'yt_the_post_format_gallery_settings', array(
				'selector' => '.slides > li',
				'controlNav' => false,
				'pausePlay' => true,
			), 'slider');
			
			if(!empty( $attachments )){
				
				$slider_count = count( $attachments );
				$output .= '<div class="yeahslider" data-settings="' . esc_attr( json_encode( $slider_settings ) ) . '">';
					$output .= '<ul class="slides">';
					$i = 0;
					foreach( $attachments as $attachment ){
						
						if( !empty( $attachment->ID ) ){
							$i++;
							$thumb_excerpt = yt_get_thumbnail_meta( $attachment->ID, 'post_excerpt' );
							$output .= sprintf( 
								'<li data-thumb="%4$s">%1$s%2$s%3$s</li>',
								wp_get_attachment_image( $attachment->ID, $size ),
								( !empty( $attachment->post_excerpt ) ? sprintf( '<div class="thumbnail-caption">%s</div>', wpautop( $attachment->post_excerpt ) ) : '' ),
								sprintf( '<span class="slide-count">%s/%s</span>', $i, $slider_count ),
								wp_get_attachment_thumb_url( $attachment->ID, 'small' )

							);
						}
					}
					$output .= '</ul>';
				$output .= '</div>';
			}
			
			
				
		}
			
		
		return apply_filters( 'yt_the_post_format_gallery_content', $output, $post->ID );
	}
}
/*
 * Theme get post formats - Audio
 *
 * @since 1.0
 * @framework 1.0
 */
if( !function_exists( 'yt_get_the_post_format_audio') ) {
	function yt_get_the_post_format_audio( $post_id = null ){
		if( empty( $post_id ) && isset( $GLOBALS['post'] ) ){
			$post = $GLOBALS['post'];
		}else{
			$post = get_post( $post_id );
		}
		if ( empty( $post ) )
			return '';
			
		$output = '';
		$formats_meta = yt_get_post_formats_meta( $post->ID );
		
		
		if( empty( $formats_meta['_format_audio_embed'] ) ){
			return '';
		}else{
			$output .= yt_get_embed( $formats_meta['_format_audio_embed'] );
		}
		
		return apply_filters( 'yt_the_post_format_audio_content', $output, $post->ID );
	}
}
/*
 * Theme get post formats - Video
 *
 * @since 1.0
 * @framework 1.0
 */
if( !function_exists( 'yt_get_the_post_format_video') ) {
	function yt_get_the_post_format_video( $post_id = null ){
		if( empty( $post_id ) && isset( $GLOBALS['post'] ) ){
			$post = $GLOBALS['post'];
		}else{
			$post = get_post( $post_id );
		}
		if ( empty( $post ) )
			return '';
			
		$output = '';
		
		$formats_meta = yt_get_post_formats_meta( $post->ID );
		
		if( empty( $formats_meta['_format_video_embed'] ) ){
			return '';
		}else{
			$output .= yt_get_embed( $formats_meta['_format_video_embed'] );
		}

		//echo $output;
		
		if( $output ){
			$poster_url = wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) );
			$poster_url = '' == $poster_url ? apply_filters( 'yt_mejs_default_media_cover', YEAHTHEMES_INCLUDES_URI . 'images/media-player-cover.jpg' ) : $poster_url;
			$poster = $poster_url ? ' poster="' . esc_url( $poster_url ) . '"' : '';
			$output = str_replace( '<video class="wp-video-shortcode"', '<video class="wp-video-shortcode"' . $poster, $output );
		}
		
		return apply_filters( 'yt_the_post_format_video_content', $output, $post->ID );
	}
}
/*
 * Theme get post formats - Link
 *
 * @since 1.0
 * @framework 1.0
 */
if( !function_exists( 'yt_get_the_post_format_link') ) {
	function yt_get_the_post_format_link( $post_id = null ){
		if( empty( $post_id ) && isset( $GLOBALS['post'] ) ){
			$post = $GLOBALS['post'];
		}else{
			$post = get_post( $post_id );
		}
		if ( empty( $post ) )
			return '';
			
		$output = '';
		$formats_meta = yt_get_post_formats_meta( $post->ID );
		
		if( empty( $formats_meta['_format_link_url'] ) ){
			return '';
		}else{
			$output .= sprintf( '<a title="%s" href="%s" target="_blank">%s</a>',
				esc_attr( $post->post_title  ),
				esc_url( $formats_meta['_format_link_url']  ),
				$formats_meta['_format_link_url']
			);
		}
		
		return apply_filters( 'yt_the_post_format_link_content', $output, $post->ID );
	}
}