<?php
$output = $title = $values = $units = $bgcolor = $custombgcolor = $options = $el_class = '';
extract( shortcode_atts( array(
    'title' => '',
    'values' => '',
    'units' => '',
    'bgcolor' => '',
    'custombgcolor' => '',
    'options' => '',
    'el_class' => ''
), $atts ) );


$el_class = $this->getExtraClass($el_class);


$bar_options = '';
$options = explode(",", $options);
if (in_array("animated", $options)) $bar_options .= " active";
if (in_array("striped", $options)) $bar_options .= " progress-bar-striped";


$classes = 'yt-vc-element yt-vc-progress-bar';
$output = '<div class="' . esc_attr( $classes ) . '">';
$output .= wpb_widget_title( array('title' => $title, 'extraclass' => 'yt-vc-element-heading') );

$graph_lines = explode(",", $values);
$max_value = 0.0;
$graph_lines_data = array();

foreach ($graph_lines as $line) {
    $new_line = array();
    $color_index = 2;
    $data = explode("|", $line);
    $new_line['value'] = isset($data[0]) ? $data[0] : 0;
    $new_line['percentage_value'] = isset($data[1]) && preg_match('/^\d{1,2}\%$/', $data[1]) ? (float)str_replace('%', '', $data[1]) : false;
    if($new_line['percentage_value']!=false) {
        $color_index+=1;
        $new_line['label'] = isset($data[2]) ? $data[2] : '';
    } else {
        $new_line['label'] = isset($data[1]) ? $data[1] : '';
    }

    $graph_lines_data[] = $new_line;
}

foreach($graph_lines_data as $line) {
    
    $output .= '<div class="progress">
    <div class="progress-bar' . ( $bgcolor ? ' ' . $bgcolor : '' ) . esc_attr( $bar_options ) . '" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: ' . $line['value'] . '%">'. $line['label'] .'</div>
    </div>';
}

$output .= '</div>';

echo $output;