<?php
$output = $title = $interval = $el_class = '';
extract( shortcode_atts( array(
	'title' => '',
	'interval' => 0,
	'el_class' => ''
), $atts ) );

$el_class = $this->getExtraClass( $el_class );

$element = 'tabs';
if ( 'vc_tour' == $this->shortcode ) $element = 'tour';

// Extract tab titles
preg_match_all( '/vc_tab([^\]]+)/i', $content, $matches, PREG_OFFSET_CAPTURE );
$tab_titles = array();
/**
 * vc_tabs
 *
 */
if ( isset( $matches[1] ) ) {
	$tab_titles = $matches[1];
}
$tabs_nav = '';
$tabs_nav .= '<ul class="nav nav-tabs' . ( 'vc_tour' == $this->shortcode ? ' tabs-left' : '') . '">';
$tab_count = 0;
foreach ( $tab_titles as $tab ) {
	$tab_count++;
	$tab_atts = shortcode_parse_atts($tab[0]);
	if(isset($tab_atts['title'])) {
		$tabs_nav .= '<li'. ( 1 == $tab_count ? ' class="active"' : '' ) .'><a href="#tab-' . ( isset( $tab_atts['tab_id'] ) ? $tab_atts['tab_id'] : sanitize_title( $tab_atts['title'] ) ) . '" data-toggle="tab">' . $tab_atts['title'] . '</a></li>';
	}
}
$tabs_nav .= '</ul>';

$output .= wpb_widget_title( array('title' => $title, 'extraclass' => 'yt-vc-element-heading') );
$output .= '<div class="yt-vc-element yt-vc-' . $element . ' clearfix' . $el_class . '">';
	$output .= $tabs_nav;
	$output .= '<div class="tab-content">';
	$output .= preg_replace( '/tab-pane/', 'tab-pane active', wpb_js_remove_wpautop( $content  ), 1 );
	$output .= '</div> ';
$output .= '</div> ';

echo $output;